package com.voxeet.sdk.events.v2;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when a new Participant is known for a Conference :
 * - invited
 * - joined (negotiated with the servers)
 *
 * Note : it does not mean the Participant is currently in the Conference
 */
@Annotate
@FromSDK
public class ParticipantAddedEvent extends SuccessEvent {

    /**
     * The Participant holding this event
     */
    @NonNull
    public Participant participant;

    /**
     * The underlying Conference instance
     */
    @NoDocumentation
    @NonNull
    public Conference conference;

    @NoDocumentation
    public ParticipantAddedEvent(@NonNull Conference conference,
                                 @NonNull Participant participant) {
        this.participant = participant;
        this.conference = conference;
    }
}
