package com.voxeet.sdk.events.success;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.json.Event;
import com.voxeet.sdk.json.EventNames;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.ArrayList;
import java.util.List;

//TODO use in conference ?
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.CONFERENCE_UPDATED)
public class ConferenceUpdated extends Event {

    private String conferenceId;

    private String conferenceAlias;

    private boolean isLive;

    private long startTimestamp;

    private List<SdkParticipant> participants;

    public List<ConferenceUser> getParticipants() {
        List<ConferenceUser> users = new ArrayList<>();
        if (null != participants) {
            for (SdkParticipant participant : participants) {
                ConferenceUser user = new ConferenceUser(participant.getUserId(),
                        null, new ParticipantInfo(participant.getMetadata().getExternalName(),
                        participant.getUserId(), participant.getMetadata().getExternalPhotoUrl()));
                user.setStatus(participant.getStatus());
                users.add(user);
            }
        }
        return users;
    }

    public String getConferenceId() {
        return conferenceId;
    }

    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public String getConferenceAlias() {
        return conferenceAlias;
    }

    public void setConferenceAlias(String conferenceAlias) {
        this.conferenceAlias = conferenceAlias;
    }

    public long getStartTimestamp() {
        return startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public boolean isLive() {
        return isLive;
    }

    public void setLive(boolean live) {
        isLive = live;
    }

    public void setParticipants(List<SdkParticipant> participants) {
        this.participants = participants;
    }

    public void setIsLive(boolean isLive) {
        this.isLive = isLive;
    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_UPDATED;
    }
}
