package com.voxeet.sdk.events.promises;

import android.support.annotation.NonNull;

import com.voxeet.sdk.models.v2.ServerErrorMessage;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ServerErrorException model represents the exception that is sent when the server returns or encounters an error. It includes the [value of the API error origin](/documentation/sdk/reference/android/models/servererrorexception#origin-servererrororigin) and the actual [error](/documentation/sdk/reference/android/models/servererrorexception#error-servererrormessage).
 */
@Annotate
public class ServerErrorException extends Throwable {

    /**
     * Enumerated value of the API origin error.
     */
    @NonNull
    public ServerErrorOrigin origin;

    /**
     * Actual error from the server including its code, reason, and description.
     */
    @NonNull
    public ServerErrorMessage error;

    private ServerErrorException() {
        origin = ServerErrorOrigin.UNDEFINED;
        error = new ServerErrorMessage();
    }

    @NoDocumentation
    public ServerErrorException(@NonNull ServerErrorMessage error,
                                @NonNull ServerErrorOrigin origin) {
        this();

        this.error = error;
        this.origin = origin;
    }
}
