package com.voxeet.sdk.events.promises;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.error.ParticipantAddedErrorEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The ParticipantAddedErrorEventException model is an exception that is emitted when it is impossible to add the participant into the local information related to the conference. It is caused by mismatch and compatibility issues related to the specific participant.
 */
@Annotate
public class ParticipantAddedErrorEventException extends Throwable {

    /**
     * The corresponding event containing all the needed information.
     */
    @NonNull
    public ParticipantAddedErrorEvent event;

    @NoDocumentation
    private ParticipantAddedErrorEventException() {

    }

    @NoDocumentation
    public ParticipantAddedErrorEventException(@NonNull ParticipantAddedErrorEvent event) {
        this.event = event;
    }
}
