/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopVideoAnswerEvent;
import com.voxeet.sdk.events.v2.VideoStateEvent;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiVideo;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class StopVideoPromise
extends AbstractPromiseable<Boolean, IRestApiVideo> {
    private static final String TAG = StopVideoPromise.class.getSimpleName();
    private final ConferenceInformationHolder conferenceInformationHolder;

    public StopVideoPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiVideo provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull ConferenceInformationHolder conferenceInformationHolder) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceInformationHolder = conferenceInformationHolder;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise(solver -> {
            this.log("stoppping video");
            MediaSDK media = this.getMedia();
            ConferenceInformation information = this.getInformation();
            if (null == media) {
                Log.d((String)TAG, (String)"stopVideo: media is null");
                Promise.reject((Throwable)new MediaEngineException("media is null"));
                return;
            }
            media.stopVideo();
            if (null == information || !this.getParent().isInConference()) {
                Log.d((String)TAG, (String)"stopVideo: not in conf");
                Promise.reject((Throwable)new NotInConferenceException());
                return;
            }
            information.setRequestedOwnVideo(false);
            if (!VideoState.STARTED.equals((Object)information.getVideoState())) {
                this.log("stopping video failed : maybe already in some...");
                Promise.reject((Throwable)new IllegalStateException("can not stop video, pending ?"));
                return;
            }
            this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPING);
            this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPING));
            String conferenceId = information.getConference().getId();
            Call<StopVideoResponse> stopVideo = ((IRestApiVideo)this.getApiRestCall()).stopVideo(conferenceId, VoxeetPreferences.id());
            HttpHelper.promise(stopVideo, ServerErrorOrigin.STOP_VIDEO).then(answer -> {
                StopVideoResponse object = (StopVideoResponse)answer.object;
                media.stopVideo();
                information.setRequestedOwnVideo(false);
                StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                this.getEventBus().post((Object)event);
                return this.createVideoAnswer(object.participantId, object.description, object.candidates);
            }).then(result -> {
                this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                solver.resolve(result);
            }).error(error -> {
                this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                solver.reject(error);
            });
        });
    }
}

