/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.PromiseSolver;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.PromisePermissionRefusedEventException;
import com.voxeet.sdk.events.v2.VideoStateEvent;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiVideo;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.sdk.utils.Validate;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class StartVideoPromise
extends AbstractPromiseable<Boolean, IRestApiVideo> {
    private static final String TAG = StartVideoPromise.class.getSimpleName();
    private final boolean isDefaultFrontFacing;
    private final ConferenceInformationHolder conferenceInformationHolder;

    public StartVideoPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiVideo provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, boolean isDefaultFrontFacing, ConferenceInformationHolder conferenceInformationHolder) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.isDefaultFrontFacing = isDefaultFrontFacing;
        this.conferenceInformationHolder = conferenceInformationHolder;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise((PromiseSolver)new PromiseSolver<Boolean>(){

            public void onCall(@NonNull Solver<Boolean> solver) {
                String defaultCameraName;
                ConferenceInformation information = StartVideoPromise.this.getInformation();
                MediaSDK media = StartVideoPromise.this.getMedia();
                CameraContext provider = StartVideoPromise.this.getMediaService().getCameraContext();
                provider.setDefaultCameraFront(StartVideoPromise.this.isDefaultFrontFacing);
                StartVideoPromise.this.log("starting video");
                if (null == media) {
                    Log.d((String)TAG, (String)"startVideo: media is null");
                    Promise.reject((Throwable)new MediaEngineException("Media is null, invalid state"));
                    return;
                }
                if (!Validate.hasCameraPermissions(StartVideoPromise.this.getParent().getContext())) {
                    PermissionRefusedEvent event = new PermissionRefusedEvent(PermissionRefusedEvent.Permission.CAMERA);
                    StartVideoPromise.this.getEventBus().post((Object)event);
                    Promise.reject((Throwable)new PromisePermissionRefusedEventException(event));
                    return;
                }
                if (null == information) {
                    Log.d((String)TAG, (String)"startVideo: information is null");
                    Promise.reject((Throwable)new MediaEngineException("ConferenceInformation is null, invalid state"));
                    return;
                }
                if (!VideoState.STOPPED.equals((Object)information.getVideoState())) {
                    StartVideoPromise.this.log("starting video failed : maybe already in some...");
                    Promise.reject((Throwable)new IllegalStateException("can not start video, pending ?"));
                    return;
                }
                if (ConferenceParticipantType.LISTENER.equals((Object)information.getConferenceParticipantType())) {
                    Log.d((String)TAG, (String)"startVideo: you are a listener, you can't start the video");
                    solver.resolve((Object)false);
                    return;
                }
                StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STARTING);
                StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STARTING));
                String string = defaultCameraName = StartVideoPromise.this.isDefaultFrontFacing ? provider.getFrontCameraName() : provider.getBackCameraName();
                if (null == defaultCameraName) {
                    Promise.reject((Throwable)new MediaEngineException("DefaultCamera is null, invalid state"));
                    return;
                }
                information.setRequestedOwnVideo(true);
                media.startVideo(defaultCameraName);
                String id = (String)Opt.of((Object)StartVideoPromise.this.getInformation()).then(ConferenceInformation::getConference).then(Conference::getId).or((Object)"");
                Call<StartVideoResponse> startVideo = ((IRestApiVideo)StartVideoPromise.this.getApiRestCall()).startVideo(id, VoxeetSdk.session().getParticipantId());
                HttpHelper.promise(startVideo, ServerErrorOrigin.START_VIDEO).then(answer -> {
                    StartVideoResponse object = (StartVideoResponse)answer.object;
                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STARTING);
                    information.setRequestedOwnVideo(true);
                    return StartVideoPromise.this.createVideoAnswer(object.participantId, object.description, object.candidates);
                }).then(result -> {
                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STARTED);
                    StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STARTED));
                    solver.resolve(result);
                }).error(error -> {
                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                    StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                    media.stopVideo();
                    information.setRequestedOwnVideo(false);
                    solver.reject(error);
                });
            }
        });
    }
}

