/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.WindowManager;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.network.endpoints.IRestApiScreenShare;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.promises.StartScreensharePromise;
import com.voxeet.sdk.services.conference.promises.StopScreenSharePromise;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.services.screenshare.RequestScreenSharePermissionEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

@Annotate
public class ScreenShareService
extends AbstractVoxeetService<IRestApiScreenShare> {
    private static final int REQUEST_SCREEN_CAPTURE = 672;
    private static final String TAG = ScreenShareService.class.getSimpleName();
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private int mLastResultCode;
    @Nullable
    private Point mLastPoint;
    @Nullable
    private Intent mLastData;

    @NoDocumentation
    public ScreenShareService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.retrofit).setService(IRestApiScreenShare.class).setEventBus(instance.voxeetSdk.getEventBus()).setClient(instance.okHttpClient).build());
    }

    @Deprecated
    @NoDocumentation
    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then((result, solver) -> Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result))).error(this.manageError());
        } else {
            VoxeetSdk.screenShare().sendRequestStartScreenShare();
        }
    }

    @NonNull
    public Promise<Boolean> startScreenShare(@NonNull Intent intent) {
        int width = 640;
        int height = 480;
        if (null != this.mLastPoint) {
            width = this.mLastPoint.x;
            height = this.mLastPoint.y;
        }
        return new StartScreensharePromise(VoxeetSdk.conference(), VoxeetSdk.mediaDevice(), (IRestApiScreenShare)this.getService(), VoxeetSdk.conference().getCurrentConference(), this.getEventBus(), intent, width, height).createPromise();
    }

    @NonNull
    public Promise<Boolean> stopScreenShare() {
        return new StopScreenSharePromise(VoxeetSdk.conference(), VoxeetSdk.mediaDevice(), (IRestApiScreenShare)this.getService(), VoxeetSdk.conference().getCurrentConference(), this.getEventBus()).createPromise();
    }

    public ScreenShareService setScreenSizeInformation(@NonNull Point point) {
        this.mLastPoint = point;
        return this;
    }

    public void sendRequestStartScreenShare() {
        this.getEventBus().post((Object)new RequestScreenSharePermissionEvent());
    }

    public boolean sendUserPermissionRequest(@NonNull Activity activity) {
        if (21 <= Build.VERSION.SDK_INT) {
            MediaProjectionManager manager = (MediaProjectionManager)activity.getSystemService("media_projection");
            Intent request = manager.createScreenCaptureIntent();
            activity.startActivityForResult(request, 672);
            return true;
        }
        return false;
    }

    public void consumeRightsToScreenShare() {
        if (this.mLastResultCode == -1 && null != this.mLastData) {
            this.startScreenShare(this.mLastData).then((result, solver) -> Log.d((String)TAG, (String)"onCall: starting screen share")).error(Throwable::printStackTrace);
            this.mLastData = null;
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 672) {
            if (-1 != resultCode) {
                VoxeetSdk.conference().onParticipantCanceledScreenShare();
            } else {
                this.mLastResultCode = resultCode;
                this.mLastData = data;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public Point getScreenSize(@NonNull Context context) {
        Point point = new Point();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (null != windowManager) {
            windowManager.getDefaultDisplay().getSize(point);
        }
        return point;
    }

    @NonNull
    public Point getScreenSizeScaled(@NonNull Point screen_size, int height) {
        Point point = new Point(screen_size);
        int screen_width = screen_size.x;
        int screen_height = screen_size.y;
        if (screen_height > 0) {
            point.y = height;
            point.x = (int)((float)(screen_width * height) * 1.0f / (float)screen_height);
        }
        return point;
    }

    private boolean isScreenShareOn() {
        ConferenceInformation information = VoxeetSdk.conference().getCurrentConference();
        return null != information && information.isScreenShareOn();
    }
}

