/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.media.audio;

import android.support.annotation.NonNull;
import com.voxeet.audio2.devices.MediaDevice;

public enum AudioRoute {
    ROUTE_HEADSET(false),
    ROUTE_PHONE(true),
    ROUTE_SPEAKER(false),
    ROUTE_BLUETOOTH(false),
    ROUTE_MEDIA(false);

    private boolean mProximitySensor;

    private AudioRoute(boolean proximity_sensor) {
        this.mProximitySensor = proximity_sensor;
    }

    public boolean useProximitySensor() {
        return this.mProximitySensor;
    }

    public static AudioRoute valueOf(int value) {
        switch (value) {
            case 0: {
                return ROUTE_HEADSET;
            }
            case 1: {
                return ROUTE_PHONE;
            }
            case 2: {
                return ROUTE_SPEAKER;
            }
            case 3: {
                return ROUTE_BLUETOOTH;
            }
            case 4: {
                return ROUTE_MEDIA;
            }
        }
        return ROUTE_SPEAKER;
    }

    public static <TYPE> AudioRoute from(@NonNull MediaDevice<TYPE> device) {
        switch (device.deviceType()) {
            case BLUETOOTH: {
                return ROUTE_BLUETOOTH;
            }
            case NORMAL_MEDIA: {
                return ROUTE_MEDIA;
            }
            case WIRED_HEADSET: {
                return ROUTE_HEADSET;
            }
            case EXTERNAL_SPEAKER: {
                return ROUTE_SPEAKER;
            }
            case INTERNAL_SPEAKER: {
                return ROUTE_PHONE;
            }
        }
        return ROUTE_MEDIA;
    }

    public boolean isCompatible(@NonNull MediaDevice device) {
        switch (device.deviceType()) {
            case BLUETOOTH: {
                return this.equals((Object)ROUTE_BLUETOOTH);
            }
            case NORMAL_MEDIA: {
                return this.equals((Object)ROUTE_MEDIA);
            }
            case WIRED_HEADSET: {
                return this.equals((Object)ROUTE_HEADSET);
            }
            case EXTERNAL_SPEAKER: {
                return this.equals((Object)ROUTE_SPEAKER);
            }
            case INTERNAL_SPEAKER: {
                return this.equals((Object)ROUTE_PHONE);
            }
        }
        return this.equals((Object)ROUTE_MEDIA);
    }
}

