package com.voxeet.sdk.services.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v2.ChatMessage;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class InternalChatMessage {
    public String title;
    public String content;
    public String type;
    public String avatarUrl;
    public Date time;
    public String name;
    public String ownerId;

    public InternalChatMessage(String messageType, @Nullable Participant participant, @NonNull ChatMessage chatMessage) {
        title = messageType;
        content = chatMessage.content;
        type = chatMessage.type.text();
        time = chatMessage.date;

        if(null != participant) {
            ownerId = participant.getId();

            ParticipantInfo participantInfo = participant.getInfo();
            if(null != participantInfo) {
                avatarUrl = participantInfo.getAvatarUrl();
                name = participantInfo.getName();
            }
        }
    }
}
