package com.voxeet.sdk.network.endpoints;

import com.voxeet.sdk.events.restapi.ReplayConferenceResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.json.SdkConferenceReplayBody;
import com.voxeet.sdk.models.v1.CreateConferenceResult;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface IRestApiConferenceAccess {

    @POST("v1/conferences/create")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Call<CreateConferenceResult> create(@Body CreateConferenceParams params);

    @GET("v1/conferences/demo")
    Call<CreateConferenceResult> demo();

    @POST("v1/conferences/{id}/replay")
    @Headers({"Content-Type: application/json", "Accept: application/json"})
    Call<ReplayConferenceResult> replay(@Path("id") String conferenceId, @Body SdkConferenceReplayBody body);

    @POST("v1/conferences/{conferenceId}/join")
    Call<ResumeConference> join(@Path("conferenceId") String conferenceId, @Body JoinParameters device);

    @POST("v1/conferences/{conferenceId}/leave")
    Call<ResponseBody> leave(@Path("conferenceId") String conferenceId);

    @POST("v1/conferences/{conferenceId}/invite")
    Call<ResponseBody> invite(@Path("conferenceId") String conferenceId, @Body SdkConferenceInvitation invitation);

    @POST("v1/conferences/{id}/decline")
    Call<ResponseBody> decline(@Path("id") String conferenceId);

}
