package com.voxeet.sdk.models.v2;

import android.support.annotation.NonNull;

import com.voxeet.sdk.services.chat.InternalChatMessage;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.Date;

/**
 * The ChatMessage model introduces the [ChatMessage](/documentation/sdk/reference/android/models/chatmessage#chatmessage) constructor enabling sending messages. It contains the [content](/documentation/sdk/reference/android/models/chatmessage#content) of the message sent via chat, sending [date](/documentation/sdk/reference/android/models/chatmessage#date), and message [type](/documentation/sdk/reference/android/models/chatmessage#type).
 */
@NoDocumentation
@Annotate
public class ChatMessage {
    /**
     * The date of the message.
     */
    public Date date;

    /**
     * The message content.
     */
    public String content;

    /**
     * The message type.
     */
    public ChatMessageType type;

    private ChatMessage() {

    }

    /**
     * A constructor that enables sending developers' messages. A message consists of the date, the content, and the type of content formatting.
     * @param date The sending date.
     * @param content The string representation of the chat message content.
     * @param type The message type used to format the message.
     */
    public ChatMessage(@NonNull Date date, @NonNull String content, @NonNull ChatMessageType type) {
        this.date = date;
        this.content = content;
        this.type = type;
    }

    @NoDocumentation
    public ChatMessage(@NonNull InternalChatMessage source) {
        date = source.time;
        content = source.content;
        type = ChatMessageType.fromString(source.type);
    }
}
