package com.voxeet.sdk.models.v1;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.voxeet.sdk.json.ParticipantInfo;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceUser {

    private String TAG = ConferenceUser.class.getSimpleName();

    @JsonIgnore
    private boolean isMuted = false;

    @JsonIgnore
    private ParticipantInfo participantInfo;

    @JsonProperty("user_id")
    private String userId;

    private String quality;

    @JsonIgnore
    private String deviceType;

    @JsonIgnore
    private String status;

    @JsonIgnore
    private ConferenceParticipantStatus conferenceStatus;

    private String conferenceStatusToString;

    private boolean isOwner;

    @JsonIgnore
    private UserProfile profile;

    private boolean isRecordingOwner = false;

    private boolean isWhispering = false;

    public ConferenceUser() {
        this.participantInfo = null;
    }

    public ConferenceUser(String userId, String device) {
        this.userId = userId;

        this.deviceType = device;

        this.conferenceStatus = ConferenceParticipantStatus.ON_AIR;

        this.participantInfo = null;

        this.isMuted = false;

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public ConferenceUser(String userId, String device, ParticipantInfo participantInfo) {
        this.userId = userId;

        this.deviceType = device;

        this.profile = new UserProfile();
        this.profile.setUserId(userId);
        this.profile.setPhotoId(participantInfo.getAvatarUrl());
        this.profile.setFirstName(participantInfo.getName());
        this.profile.setLastName(participantInfo.getName());
        this.profile.setNickName(participantInfo.getName());

        this.setWhispering(false);

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());

        this.participantInfo = participantInfo;

        this.isMuted = false;
    }

    public ConferenceUser(UserProfile profile) {
        this.profile = profile;

        this.userId = profile.getUserId();

        this.setConferenceStatus(ConferenceParticipantStatus.IN_PROGRESS);

        this.setQuality(ConferenceQuality.ULTRA_HIGH.StringValue());
    }

    public boolean isRecordingOwner() {
        return isRecordingOwner;
    }

    public boolean isWhispering() {
        return isWhispering;
    }

    public void setOwner(boolean owner) {
        isOwner = owner;
    }

    public void setRecordingOwner(boolean recordingOwner) {
        isRecordingOwner = recordingOwner;
    }

    public void setWhispering(boolean whispering) {
        isWhispering = whispering;
    }

    public void setIsRecordingOwner(boolean isRecordingOwner) {
        this.isRecordingOwner = isRecordingOwner;
    }

    public ConferenceParticipantStatus getConferenceStatus() {
        if (conferenceStatus == null && conferenceStatusToString != null)
            return ConferenceParticipantStatus.valueOf(conferenceStatusToString);
        return conferenceStatus;
    }

    public ConferenceUser setConferenceStatus(@NonNull ConferenceParticipantStatus conferenceStatus) {
        this.conferenceStatus = conferenceStatus;

        this.conferenceStatusToString = conferenceStatus.toString();
        return this;
    }

    public UserProfile getProfile() {
        return profile;
    }

    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    @Deprecated
    public String getStatus() {
        //return status
        return getConferenceStatusToString();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setParticipantInfo(ParticipantInfo participantInfo) {
        this.participantInfo = participantInfo;
    }

    public String getQuality() {
        return quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public ParticipantInfo getParticipantInfo() {
        return participantInfo;
    }

    public boolean isMuted() {
        return isMuted;
    }

    public void setMuted(boolean muted) {
        isMuted = muted;
    }

    public String getConferenceStatusToString() {
        return conferenceStatusToString;
    }

    public void setConferenceStatusToString(String conferenceStatusToString) {
        this.conferenceStatusToString = conferenceStatusToString;
    }

    public boolean isOwner() {
        return isOwner;
    }

    public ConferenceUser setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    @Override
    public String toString() {
        return "ConferenceUser{" +
                "participantInfo=" + participantInfo +
                ", participantId='" + userId + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) return false;

        if (obj instanceof ConferenceUser) {
            ConferenceUser user = (ConferenceUser) obj;
            return null != user.getUserId() && user.getUserId().equals(getUserId());
        }
        return super.equals(obj);
    }

    public void updateIfNeeded(String name, String avatarUrl) {
        if (null == participantInfo) {
            participantInfo = new ParticipantInfo();
        }

        participantInfo.setName(name);
        participantInfo.setAvatarUrl(avatarUrl);
    }
}