package com.voxeet.sdk.media.camera;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.sdk.utils.NoDocumentation;

import org.webrtc.CameraEnumerator;

/**
 *
 * @param <ENUMERATOR>
 */
public abstract class CameraContext<ENUMERATOR extends CameraEnumerator> {

    private ENUMERATOR enumerator;
    private String defaultName;

    private CameraContext() {
        defaultName = null;
    }

    @NoDocumentation
    CameraContext(ENUMERATOR enumerator) {
        this();

        this.enumerator = enumerator;

        defaultName = getFrontCameraName();

        if (null == defaultName) {
            defaultName = getBackCameraName();
        }

        if (null == defaultName) {
            String[] names = getDevicesName();
            defaultName = names.length > 0 ? names[0] : null;
        }
    }

    final ENUMERATOR getEnumerator() {
        return enumerator;
    }

    @NonNull
    final String[] getDevicesName() {
        try {
            String[] result = enumerator.getDeviceNames();
            if (null != result) return result;
        } catch (Error e) {
            e.printStackTrace();
        }

        return new String[]{};
    }

    public void setDefaultCameraFront(boolean isDefaultFront) {
        String newDefaultName = isDefaultFront ? getFrontCameraName() : getBackCameraName();

        //if one of the previous calls made a null value, we iterate over the two possible states
        //easier to maintain an "at least if possible" if follow than actual 2 branches with 2 calls
        if (null == newDefaultName) newDefaultName = getBackCameraName();
        if (null == newDefaultName) newDefaultName = getFrontCameraName();

        if (null != newDefaultName) this.defaultName = newDefaultName;
    }

    @Nullable
    public final String getDefaultName() {
        return defaultName;
    }

    @Nullable
    public abstract String getFrontCameraName();

    /**
     * Get the camera name
     * @return get the first back camera name available
     */
    @Nullable
    public abstract String getBackCameraName();

    /**
     * Check the front/back status
     * @return the front status of the current default camera
     */
    public final boolean isDefaultFrontFacing() {
        return isFrontFacing(defaultName);
    }

    /**
     * Get the front or back information for any given camera name
     *
     * @param deviceName a name to check against
     * @return the front status of the camera if exists
     */
    public final boolean isFrontFacing(@Nullable String deviceName) {
        try {
            return enumerator.isFrontFacing(deviceName);
        } catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }
}
