package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the recording state of the conference is updated from the remote location.
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.RECORDING_STATUS_UPDATE)
public class RecordingStatusUpdatedEvent extends Event {

    /**
     * The ID of the recorded conference.
     */
    @JsonProperty("conference_id")
    public String conferenceId;

    /**
     * The ID of the Participant that records the conference.
     */
    @JsonProperty("user_id")
    public String participantId;

    /**
     * The representation of raw recording status.
     */
    @JsonProperty("recording_status")
    public String recordingStatus;

    /**
     * The corresponding timestamp.
     */
    @JsonProperty("start_record_timestamp")
    public long timeStamp;

    @NoDocumentation
    public RecordingStatusUpdatedEvent() {

    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.RECORDING_STATUS_UPDATE;
    }
}
