package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.UserProfile;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;

import java.util.List;

@InternalEvent
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.INVITATION_RECEIVED)
public class InvitationReceivedEvent extends Event {

    public ParticipantInviter inviter;

    @JsonProperty("userId")
    public String participantId;

    public String conferenceId;

    public String meetingId;

    public UserProfile ownerProfile;

    public String title;

    public String description;

    public List<Invitation> invitations;

    public String conferenceHost;

    public String conferencePort;

    public String conferenceSecurityToken;

    @JsonProperty("conferenceInfo")
    public Conference conference;

    @Override
    public String getType() {
        return EventNames.INVITATION_RECEIVED;
    }

    public ParticipantInviter getInviter() {
        return inviter;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public class ParticipantInviter {

        @JsonProperty("userId")
        public String participantId;

        public String externalId;

        public String externalAvatarUrl;

        public String nickName;


        /*
        "proVersion" : null,
        "city" : null,
        "timezone" : null,
        "firstName" : null,
        "lastName" : null,
        "photoId" : null,
        "participantId" : null,
        "mailLocalPartId" : null,
        "selectedNodeSetAsString" : null,
        "login" : null,
        "profileType" : null,
        "statusPhrase" : null,
        "nickName" : null,
        "locale" : null,
        "jobTitle" : null,
        "company" : null,
        "creationUtcTimestamp" : 0,
        "externalAvatarUrl" : null,
        "externalId" : null,
        "updateUtcTimestamp" : 0,
        "mailLocalPart" : null,
        "country" : null,
        "manager" : null,
        "profileIdAsString" : null,
        "proTeamVersion" : null,
        "pstnSelectedNodeSet" : null,
        "mailLocalPartWithId" : null,
        "pro" : null
         */
    }
}
