package com.voxeet.sdk.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.InternalEvent;
import com.voxeet.sdk.utils.NoDocumentation;

@InternalEvent
@FromWebsocket
@JsonTypeName(EventNames.CONFERENCE_MESSAGE_RECEIVED)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceMessageReceived extends Event {

    @JsonProperty("user_id")
    public String userId;

    @JsonProperty("conference_id")
    public String conferenceId;

    public String message;

    public String externalId;

    @JsonProperty("message_type")
    public String messageType;

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.CONFERENCE_MESSAGE_RECEIVED;
    }
}
