package com.voxeet.sdk.events.sdk;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the maximum awaiting time is set and during this time nobody joined the current participant at the conference.
 */
@Annotate
@FromSDK
public class ConferenceTimeoutNoParticipantsJoinedEvent {

    /**
     * A timeout corresponding to the timeout set in the SDK.
     */
    public long timeout;

    @NoDocumentation
    public ConferenceTimeoutNoParticipantsJoinedEvent(long timeout) {
        this.timeout = timeout;
    }
}
