package com.voxeet.sdk.events.sdk;

import android.support.annotation.NonNull;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Event fired when the specified Participant's quality has been updated
 */
@Annotate
@FromSDK
public class ConferenceParticipantQualityUpdatedEvent extends SuccessEvent {

    /**
     * The specified participant. The new quality is available in the quality field;
     */
    public Participant participant;

    @NoDocumentation
    public ConferenceParticipantQualityUpdatedEvent(@NonNull Participant participant) {
        this.participant = participant;
    }
}
