package com.voxeet.sdk.events.error;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.models.v2.ServerErrorMessage;

import java.io.IOException;

import okhttp3.ResponseBody;
import retrofit2.Response;

public class HttpException extends IOException {
    @Nullable
    public Response response;

    @Nullable
    public okhttp3.Response okHttp3Response;

    @NonNull
    public ServerErrorMessage error;

    private HttpException() {

    }

    public HttpException(@NonNull okhttp3.Response fromOkHttp3) {
        okHttp3Response = fromOkHttp3;
        error = new ServerErrorMessage();
    }

    public <T> HttpException(@NonNull Response<T> response) {
        this();
        this.response = response;

        String bodyError = HttpException.bodyError(response);
        error = new ServerErrorMessage();

        if (null != bodyError) {
            ServerErrorMessage tmp = EventsFactory.mapping(bodyError, ServerErrorMessage.class);
            if (null != tmp) error = tmp;
        }

    }

    @Nullable
    public Response getResponse() {
        return response;
    }

    @Nullable
    public okhttp3.Response getOkHttp3Response() {
        return okHttp3Response;
    }

    @NonNull
    public static <T> HttpException throwResponse(Response<T> response) {
        try {
            throw new HttpException(response);
        } catch (HttpException e) {
            return e;
        }
    }

    @NonNull
    public static HttpException throwResponse(okhttp3.Response response) {
        HttpException.dumpErrorResponse(response);
        try {
            throw new HttpException(response);
        } catch (HttpException e) {
            return e;
        }
    }

    @Nullable
    public static <T> String bodyError(@Nullable Response<T> response) {
        if (null == response) {
            Log.d("HttpException", "dumpErrorResponse: http call empty response :: network error");
            return null;
        }
        ResponseBody body = response.errorBody();

        if (null != body) {
            try {
                return body.string();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T> void dumpErrorResponse(@Nullable Response<T> response) {
        if (null == response) {
            Log.d("HttpException", "dumpErrorResponse: http call empty response :: network error");
            return;
        }
        ResponseBody body = response.errorBody();

        if (null != body) {
            try {
                String string = body.string();

                Log.d("HttpException", "dumpErrorRespollllnse: http call exception := " + string);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> void dumpErrorResponse(@Nullable okhttp3.Response response) {
        if (null == response) {
            Log.d("HttpException", "dumpErrorResponse: http call empty response :: network error");
            return;
        }
        ResponseBody body = response.body();

        if (null != body) {
            try {
                String string = body.string();

                Log.d("HttpException", "dumpErrorRespoeeeense: http call exception := " + string);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
