/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.sdk.ConferenceParticipantsInvitedResult;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class GetConferenceStatus
extends AbstractPromiseable<ConferenceParticipantsInvitedResult, IRestApiOutConference> {
    public GetConferenceStatus(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiOutConference provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceParticipantsInvitedResult> createPromise() {
        return new Promise(solver -> {
            if (null == this.getInformation()) {
                Promise.reject((Solver)solver, (Throwable)new IllegalStateException("invalid conference"));
            }
            Call<ConferenceStatusResult> user = ((IRestApiOutConference)this.getApiRestCall()).conferenceStatus(this.getInformation().getConference().getId());
            HttpHelper.enqueue(user, (response, object, exception) -> {
                if (null != exception) {
                    this.log("Error while retrieving conference participants status");
                    solver.reject(HttpHelper.manageThrowableOrServerError(exception, ServerErrorOrigin.CONFERENCE_STATUS));
                } else {
                    List<ConferenceUser> users = ConferenceUtils.getConferenceUserInState((List)Opt.of((Object)object).then(ConferenceStatusResult::getConferenceUsers).or(new ArrayList()), ConferenceParticipantStatus.CONNECTING);
                    this.log("Successfully retrieved connecting users");
                    ConferenceParticipantsInvitedResult event = new ConferenceParticipantsInvitedResult(users);
                    solver.resolve((Object)event);
                }
            });
        });
    }
}

