/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.json.CreateConferenceParams;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.utils.HttpHelper;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;

public class CreateConferencePromiseable
extends AbstractPromiseable<CreateConferenceResult, IRestApiConferenceAccess> {
    private String conferenceAlias;
    private MetadataHolder metadata;
    private ParamsHolder params = null;

    public CreateConferencePromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull IRestApiConferenceAccess provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder params) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceAlias = conferenceAlias;
        this.metadata = metadata;
        this.params = params;
    }

    @Override
    @NonNull
    public Promise<CreateConferenceResult> createPromise() {
        Promise promise = new Promise(solver -> {
            this.getEventBus().post((Object)new ConferenceStatusUpdatedEvent(this.conferenceAlias, ConferenceStatus.CREATING));
            this.log("Attempting to create mConferene alias:=" + this.conferenceAlias);
            CreateConferenceParams arg = new CreateConferenceParams().setMetadataHolder(this.metadata).setParamsHolder(this.params);
            if (null != this.conferenceAlias) {
                arg.setConferenceAlias(this.conferenceAlias);
            }
            this.internalCreate(arg, (Solver<CreateConferenceResult>)solver);
        });
        if (VoxeetSdk.session().isSocketOpen()) {
            return promise;
        }
        return new Promise(solver -> VoxeetSdk.session().open().then(result -> promise).then(arg_0 -> ((Solver)solver).resolve(arg_0)).error(arg_0 -> ((Solver)solver).reject(arg_0)));
    }

    private void internalCreate(CreateConferenceParams params, Solver<CreateConferenceResult> solver) {
        Call<CreateConferenceResult> observable = ((IRestApiConferenceAccess)this.getApiRestCall()).create(params);
        HttpHelper.enqueue(observable, (response, object, e) -> {
            if (null != e) {
                e.printStackTrace();
                ConferenceStatusUpdatedEvent state = new ConferenceStatusUpdatedEvent(params.conferenceAlias, ConferenceStatus.ERROR);
                this.setIsInConference(false);
                this.closeMedia();
                this.getEventBus().post((Object)state);
                this.log("Error while create conference : creation process part");
                solver.reject(HttpHelper.manageThrowableOrServerError(e, ServerErrorOrigin.CREATE));
            } else {
                ConferenceInformation information = this.createOrSetConferenceWithParams(object.conferenceId, object.conferenceAlias);
                information.setConferenceState(ConferenceStatus.CREATED);
                information.setConferenceType(LocalConferenceType.CONFERENCE);
                Conference conference = information.getConference();
                this.getEventBus().post((Object)new ConferenceStatusUpdatedEvent(conference, conference.getState()));
                this.log("internalCreate onNext: join with := " + object.conferenceId + " " + object.conferenceAlias);
                information.getConference().setConferenceId(object.conferenceId);
                this.log("now conference is " + information.getConference().getId());
                solver.resolve(object);
            }
        });
    }
}

