/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.error.SdkLogoutErrorEvent;
import com.voxeet.sdk.events.error.SocketConnectErrorEvent;
import com.voxeet.sdk.events.sdk.SdkLogoutSuccessEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.log.factory.LogFactory;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.network.websocket.VoxeetWebSocket;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.VoxeetHttp;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class SessionService
extends AbstractVoxeetService {
    private static final String TAG = SessionService.class.getSimpleName();
    private VoxeetWebSocket _voxeet_websocket;
    private List<Solver<Boolean>> mWaitForLogInSocket;
    private ReentrantLock lockConnectAttempt = new ReentrantLock();
    @Nullable
    private ParticipantInfo _participant_infos;

    @NoDocumentation
    public SessionService(@NonNull SdkEnvironmentHolder instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.mWaitForLogInSocket = new ArrayList<Solver<Boolean>>();
        this._voxeet_websocket = new VoxeetWebSocket(instance.voxeetSdk, instance.voxeetEnvironmentHolder.getSocketUrl());
        this.registerEventBus();
    }

    @NoDocumentation
    public void connectSocket(VoxeetHttp provider) {
        this._voxeet_websocket.connect(provider);
    }

    @NonNull
    public Promise<Boolean> open(@NonNull ParticipantInfo participantInfo) {
        this._participant_infos = participantInfo;
        return this.open();
    }

    @NonNull
    public Promise<Boolean> open() {
        if (null == this._participant_infos) {
            this.rejectParticipantNull("login");
        }
        if (this.isSocketOpen()) {
            return new Promise(solver -> {
                Log.d((String)TAG, (String)"onCall: socket opened");
                this.lockConnectAttempt();
                this.resolveLoginSockets();
                this.unlockConnectAttempt();
                solver.resolve((Object)true);
            });
        }
        return new Promise(solver -> {
            if (null != this._voxeet_websocket && this.isSocketOpen()) {
                this._voxeet_websocket.close(true);
            }
            Log.d((String)TAG, (String)"onCall: start login in promise");
            this.lockConnectAttempt();
            Log.d((String)TAG, (String)("onCall: having the list with elements := " + this.mWaitForLogInSocket));
            if (this.mWaitForLogInSocket.size() == 0) {
                this.mWaitForLogInSocket.add((Solver<Boolean>)solver);
                this.unlockConnectAttempt();
                this.IdentifyInlogin().then(result -> Log.d((String)TAG, (String)"onCall: first login part done")).error(error -> {
                    Log.d((String)TAG, (String)("onError: login error " + error.getMessage()));
                    this.lockConnectAttempt();
                    this.rejectLoginSockets(error);
                    this.clearLoginSockets();
                    this.unlockConnectAttempt();
                    Log.d((String)TAG, (String)"onError: login error managed");
                });
            } else {
                Log.d((String)TAG, (String)"onCall: already have a login attempt in progress");
                Promise.reject((Throwable)new IllegalStateException("Can not open a session while an other one is trying to be started"));
                this.unlockConnectAttempt();
            }
            Log.d((String)TAG, (String)"onCall: start login done... can take a time");
        });
    }

    @NoDocumentation
    public void closeSocket() {
        this._voxeet_websocket.close(true);
    }

    @Deprecated
    @NoDocumentation
    public void cleanParticipantSession(@NonNull String id) {
        this.getVoxeetHttp().cleanParticipantSession(id);
    }

    public boolean isSocketOpen() {
        return this._voxeet_websocket.isOpen();
    }

    @NoDocumentation
    @Nullable
    public ParticipantInfo getParticipantInfo() {
        return this._participant_infos;
    }

    @NoDocumentation
    @Nullable
    public String getParticipantId() {
        return VoxeetPreferences.id();
    }

    @NoDocumentation
    @Nullable
    public Participant getParticipant() {
        String id = this.getParticipantId();
        ParticipantInfo participantInfo = this.getParticipantInfo();
        return null != id ? new Participant(id, participantInfo) : null;
    }

    public boolean isLocalParticipant(@NonNull Participant participant) {
        String id = participant.getId();
        return null != id && id.equals(this.getParticipantId());
    }

    @NonNull
    public Promise<Boolean> close() {
        return new Promise(solver -> {
            LogFactory.instance.disconnect();
            Log.d((String)TAG, (String)"onCall: logout called");
            ConferenceService service = VoxeetSdk.conference();
            this.lockConnectAttempt();
            if (!this.isInProperServiceState(service)) {
                try {
                    this.throwInvalidServices();
                }
                catch (IllegalStateException e) {
                    this.rejectLoginSockets(e);
                    solver.reject((Throwable)e);
                }
                return;
            }
            try {
                throw new IllegalStateException("You have awaiting login, the logout automatically canceled those");
            }
            catch (Exception e) {
                this.rejectLoginSockets(e);
                this.clearLoginSockets();
                this.unlockConnectAttempt();
                try {
                    service.clearConferencesInformation();
                    if (service.isLive()) {
                        service.leave().then((result, solver1) -> Log.d((String)TAG, (String)"onCall: leaving while logging out done")).error(error -> {
                            Log.d((String)TAG, (String)"onError: leaving when logout error -- for information :");
                            error.printStackTrace();
                        });
                    }
                }
                catch (Exception e2) {
                    Log.d((String)TAG, (String)"onCall: WARNING :: please report this error :");
                    e2.printStackTrace();
                }
                Log.d((String)TAG, (String)"onCall: clean awaiting sockets done");
                this.closeInSafeState().then((result, s) -> {
                    Log.d((String)TAG, (String)("onCall: logout result := " + result + " ... propagating..."));
                    solver.resolve(result);
                }).error(arg_0 -> ((Solver)solver).reject(arg_0));
                return;
            }
        });
    }

    private Promise<Boolean> closeInSafeState() {
        return new Promise(solver -> {
            String id = this.getParticipantId();
            if (null != id) {
                Log.d((String)TAG, (String)"Attempting to logout");
                this.getVoxeetHttp().logout(id).then((result, internal_solver) -> {
                    VoxeetPreferences.onLogout();
                    this.closeSocket();
                    if (null != result && result.booleanValue()) {
                        String message = "Logout success";
                        this.getEventBus().post((Object)new SdkLogoutSuccessEvent(message));
                        solver.resolve((Object)true);
                    } else {
                        String message = "Logout failed";
                        this.getEventBus().post((Object)new SdkLogoutErrorEvent(message));
                        solver.resolve((Object)false);
                    }
                }).error(error -> {
                    error.printStackTrace();
                    VoxeetPreferences.onLogout();
                    this.closeSocket();
                    this.getEventBus().post((Object)new SdkLogoutErrorEvent(this.handleError(error)));
                    solver.reject(error);
                });
            } else {
                String message = "Already logged out";
                Log.d((String)TAG, (String)"Already logged out");
                this.getEventBus().post((Object)new SdkLogoutSuccessEvent("Already logged out"));
                solver.resolve((Object)true);
            }
        });
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketStateChangeEvent event) {
        if (WebSocketState.CONNECTED.equals((Object)event.state)) {
            this.lockConnectAttempt();
            this.resolveLoginSockets();
            this.unlockConnectAttempt();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(SocketConnectErrorEvent event) {
        this.lockConnectAttempt();
        for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
            Log.d((String)TAG, (String)"onEvent: calling resolved false");
            Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
            try {
                solver.resolve((Object)false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.clearLoginSockets();
        this.unlockConnectAttempt();
    }

    @NonNull
    private Promise<Boolean> IdentifyInlogin() {
        if (null == this._participant_infos) {
            return this.rejectParticipantNull("on login attempt");
        }
        return this.getVoxeetHttp().identifyChain(this._participant_infos);
    }

    private void lockConnectAttempt() {
        try {
            this.lockConnectAttempt.lock();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void unlockConnectAttempt() {
        try {
            if (this.lockConnectAttempt.isLocked()) {
                this.lockConnectAttempt.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rejectLoginSockets(@NonNull Throwable error) {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onError: calling reject");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.reject(error);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private void resolveLoginSockets() {
        try {
            for (int i = 0; i < this.mWaitForLogInSocket.size(); ++i) {
                Log.d((String)TAG, (String)"onEvent: calling resolved true");
                Solver<Boolean> solver = this.mWaitForLogInSocket.get(i);
                try {
                    solver.resolve((Object)true);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clearLoginSockets();
    }

    private void clearLoginSockets() {
        try {
            this.mWaitForLogInSocket.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Promise<Boolean> rejectParticipantNull(@NonNull String origin) {
        return Promise.reject((Throwable)new IllegalStateException("Invalid ! participant not set ! sent from " + origin));
    }
}

