/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.MediaStreamType;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.Solver;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.authent.models.DeviceType;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.ParticipantAddedErrorEvent;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.promises.ParticipantAddedErrorEventException;
import com.voxeet.sdk.events.promises.ServerErrorException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.events.sdk.ConferenceHistoryResult;
import com.voxeet.sdk.events.sdk.ConferenceParticipantQualityUpdatedEvent;
import com.voxeet.sdk.events.sdk.ConferenceParticipantsInvitedResult;
import com.voxeet.sdk.events.sdk.ConferenceStatusUpdatedEvent;
import com.voxeet.sdk.events.sdk.IncomingCallEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.events.v2.ParticipantAddedEvent;
import com.voxeet.sdk.events.v2.ParticipantUpdatedEvent;
import com.voxeet.sdk.events.v2.StreamAddedEvent;
import com.voxeet.sdk.events.v2.StreamRemovedEvent;
import com.voxeet.sdk.events.v2.StreamUpdatedEvent;
import com.voxeet.sdk.events.websocket.RenegociationEndedEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceCreated;
import com.voxeet.sdk.json.OwnConferenceParticipantSwitch;
import com.voxeet.sdk.json.ParticipantAdded;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.json.QualityUpdated;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.audio.AudioRoute;
import com.voxeet.sdk.media.audio.ParticipantPosition;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.media.peer.SdpMessage;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.Conference;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.models.v1.RestParticipant;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.network.endpoints.IRestApiMedia;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.network.endpoints.IRestApiSimulcast;
import com.voxeet.sdk.network.endpoints.IRestApiVideo;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.push.center.invitation.InvitationBundle;
import com.voxeet.sdk.push.center.management.PushConferenceDestroyed;
import com.voxeet.sdk.services.AbstractVoxeetService;
import com.voxeet.sdk.services.AudioService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.SdkEnvironmentHolder;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.TimeoutRunnable;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.services.builders.ConferenceCreateOptions;
import com.voxeet.sdk.services.builders.ConferenceJoinInformation;
import com.voxeet.sdk.services.conference.ConferenceConfigurations;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.conference.information.ConferenceParticipantType;
import com.voxeet.sdk.services.conference.information.ConferenceStatus;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.services.conference.promises.CreateConferencePromiseable;
import com.voxeet.sdk.services.conference.promises.DeclinePromise;
import com.voxeet.sdk.services.conference.promises.GetConferenceHistoryPromiseable;
import com.voxeet.sdk.services.conference.promises.GetConferenceStatus;
import com.voxeet.sdk.services.conference.promises.GetConferenceStatusPromiseable;
import com.voxeet.sdk.services.conference.promises.InvitePromise;
import com.voxeet.sdk.services.conference.promises.JoinPromise;
import com.voxeet.sdk.services.conference.promises.LeavePromise;
import com.voxeet.sdk.services.conference.promises.ReplayPromise;
import com.voxeet.sdk.services.conference.promises.SimulcastPromiseable;
import com.voxeet.sdk.services.conference.promises.StartVideoPromise;
import com.voxeet.sdk.services.conference.promises.StopVideoPromise;
import com.voxeet.sdk.services.conference.promises.SubscribeConferenceEventPromiseable;
import com.voxeet.sdk.services.conference.promises.SubscribeForCallStartPromiseable;
import com.voxeet.sdk.services.conference.promises.UnsubscribeConferenceEventPromiseable;
import com.voxeet.sdk.services.conference.promises.UnsubscribeForCallStartPromiseable;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.services.simulcast.ParticipantQuality;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Opt;
import com.voxeet.sdk.utils.ParticipantUtils;
import com.voxeet.sdk.utils.PeerInformation;
import com.voxeet.sdk.utils.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.CameraVideoCapturer;
import retrofit2.Call;
import retrofit2.Response;

@Annotate
public class ConferenceService
extends AbstractVoxeetService<IRestApiConferenceAccess> {
    private static final String TAG = ConferenceService.class.getSimpleName();
    private final IRestApiConferenceAccess conferenceAccess;
    private final IRestApiSimulcast simulcastAccess;
    private final IRestApiMedia mediaAccess;
    private final IRestApiOutConference outConferenceAccess;
    private final IRestApiVideo videoAccess;
    private EventBus mEventBus;
    private boolean mInConference = false;
    private ReentrantLock joinLock = new ReentrantLock();
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    public final ConferenceConfigurations ConferenceConfigurations = new ConferenceConfigurations();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamAddedFromInformation(peerInformation, stream);
        }

        public void onStreamUpdated(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamUpdatedFromInformation(peerInformation, stream);
        }

        public void onStreamRemoved(@NonNull String peer) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamRemovedFromInformation(peerInformation);
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.ScreenShare);
            this.onStreamAddedFromInformation(peerInformation, stream);
        }

        public void onScreenStreamRemoved(@NonNull String peer) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.ScreenShare);
            this.onStreamRemovedFromInformation(peerInformation);
        }

        private void onStreamAddedFromInformation(@NonNull PeerInformation peerInformation, @NonNull MediaStream stream) {
            String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)("onStreamAdded: stream for peer " + peer + " " + stream.getType()));
            ConferenceService.this.postOnMainThread(() -> {
                ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConference();
                Participant participant = ConferenceService.this.findParticipantById(peer);
                Log.d((String)"DUMP_INFORMATION", (String)("New stream for participant " + peer + " participant := " + participant));
                if (null != conferenceInformation && null == participant) {
                    Log.d((String)TAG, (String)("run: WARNING obtained stream for participant which did not existed " + peer));
                    participant = new Participant(peer, null);
                    conferenceInformation.getConference().updateParticipant(participant);
                }
                if (null != conferenceInformation) {
                    if (!peer.equalsIgnoreCase(VoxeetSdk.session().getParticipantId()) && ConferenceService.this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout != -1L) {
                        ConferenceService.this.removeTimeoutCallbacks();
                    }
                    participant.streamsHandler().insertOrUpdate(stream);
                    ConferenceService.this.updateConferenceFromParticipants();
                    ConferenceService.this.mEventBus.post((Object)new StreamAddedEvent(conferenceInformation.getConference(), participant, stream));
                } else {
                    Log.d((String)TAG, (String)"run: unknown participant in stream added");
                }
            });
        }

        private void onStreamUpdatedFromInformation(@NonNull PeerInformation peerInformation, @NonNull MediaStream stream) {
            String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)("onStreamUpdated: screen for peer " + peer));
            ConferenceService.this.postOnMainThread(() -> {
                ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConference();
                Participant participant = ConferenceService.this.findParticipantById(peer);
                if (null != conferenceInformation && null == participant) {
                    Log.d((String)"DUMP_INFORMATION", (String)("run: WARNING obtained stream for participant which did not existed " + peer));
                    participant = new Participant(peer, null);
                    conferenceInformation.getConference().updateParticipant(participant);
                }
                Log.d((String)TAG, (String)("Updated stream for participant " + participant));
                if (null != conferenceInformation) {
                    participant.streamsHandler().insertOrUpdate(stream);
                    ConferenceService.this.updateConferenceFromParticipants();
                    ConferenceService.this.mEventBus.post((Object)new StreamUpdatedEvent(conferenceInformation.getConference(), participant, stream));
                } else {
                    Log.d((String)TAG, (String)"run: unknown participant in stream updated");
                }
            });
        }

        void onStreamRemovedFromInformation(@NonNull PeerInformation peerInformation) {
            String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)"onStreamRemoved: OnStreamRemoved");
            ConferenceService.this.postOnMainThread(() -> ConferenceService.this.removeStreamForParticipant(peer, peerInformation.calculatedMediaStreamType));
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == ConferenceService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = ConferenceService.this.mediaAccess.candidates(ConferenceService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            HttpHelper.enqueue(call, (response, object, exception) -> {
                if (null != exception) {
                    exception.printStackTrace();
                } else {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }
            });
        }
    };
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String s) {
            Log.d((String)TAG, (String)"onCameraError: error...");
            ConferenceService.this.stopVideo().then(result -> Log.d((String)TAG, (String)("onCall: stopped video after camera issue " + result))).error(Throwable::printStackTrace);
        }

        public void onCameraDisconnected() {
            Log.d((String)TAG, (String)"onCameraDisconnected");
        }

        public void onCameraFreezed(String s) {
            Log.d((String)TAG, (String)("onCameraFreezed: " + s));
        }

        public void onCameraOpening(String s) {
            Log.d((String)TAG, (String)("onCameraOpening: " + s));
        }

        public void onFirstFrameAvailable() {
            Log.d((String)TAG, (String)"onFirstFrameAvailable");
        }

        public void onCameraClosed() {
            Log.d((String)TAG, (String)"onCameraClosed");
        }
    };

    private void removeStreamForParticipant(@NonNull String peer, MediaStreamType mediaStreamType) {
        ConferenceInformation conferenceInformation = this.getCurrentConference();
        Participant participant = this.findParticipantById(peer);
        if (null != conferenceInformation && null == participant) {
            Log.d((String)TAG, (String)("run: WARNING obtained stream for participant which did not existed " + peer));
            participant = new Participant(peer, null);
            conferenceInformation.getConference().updateParticipant(participant);
        }
        Log.d((String)TAG, (String)("Remove stream " + mediaStreamType + " for participant " + participant));
        if (null != conferenceInformation) {
            MediaStream stream = participant.streamsHandler().getFirst(mediaStreamType);
            participant.streamsHandler().remove(mediaStreamType);
            this.updateConferenceFromParticipants();
            this.mEventBus.post((Object)new StreamRemovedEvent(conferenceInformation.getConference(), participant, stream));
        } else {
            Log.d((String)TAG, (String)("run: unknown participant in stream updated" + Arrays.toString(this.getParticipants().toArray())));
        }
    }

    @NoDocumentation
    public ConferenceService(@NonNull SdkEnvironmentHolder instance, long timeout) {
        super(instance, IRestApiConferenceAccess.class);
        this.conferenceAccess = (IRestApiConferenceAccess)instance.retrofit.create(IRestApiConferenceAccess.class);
        this.mediaAccess = (IRestApiMedia)instance.retrofit.create(IRestApiMedia.class);
        this.outConferenceAccess = (IRestApiOutConference)instance.retrofit.create(IRestApiOutConference.class);
        this.videoAccess = (IRestApiVideo)instance.retrofit.create(IRestApiVideo.class);
        this.simulcastAccess = (IRestApiSimulcast)instance.retrofit.create(IRestApiSimulcast.class);
        this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout = timeout;
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.voxeetSdk.getApplicationContext();
        this.ConferenceConfigurations.automaticTelecomModePrefix = AndroidManifest.readMetadata(this.mContext, "voxeet_automatic_telecom_conference_alias_prefix", null);
        this.registerEventBus();
    }

    public boolean mute(boolean mute) {
        MediaEngine media = (MediaEngine)Opt.of((Object)VoxeetSdk.mediaDevice()).then(MediaDeviceService::getMedia).orNull();
        if (null != media) {
            if (!mute && media.isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                media.unMute();
            } else if (mute) {
                media.mute();
            }
        }
        return true;
    }

    public boolean isMuted() {
        return (Boolean)Opt.of((Object)((Object)VoxeetSdk.mediaDevice().getMedia())).then(MediaEngine::isMuted).or((Object)true);
    }

    @Deprecated
    @NoDocumentation
    public boolean isParticipantMuted(String participantId) {
        return false;
    }

    @NoDocumentation
    @Nullable
    public String currentSpeaker() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        com.voxeet.sdk.models.Conference conference = this.getConference();
        if (null == media || conference == null) {
            return VoxeetSdk.session().getParticipantId();
        }
        String currentSpeaker = null;
        for (Participant participant : conference.getParticipants()) {
            if (participant.getId() == null || participant.getId().equals(VoxeetPreferences.id()) || !participant.isLocallyActive()) continue;
            double peerVuMeter = media.getPeerVuMeter(participant.getId());
            if (Double.isNaN(peerVuMeter)) {
                peerVuMeter = 0.0;
            }
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(media.getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = participant.getId();
        }
        return currentSpeaker;
    }

    public boolean isParticipantSpeaking(@NonNull Participant participant) {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        com.voxeet.sdk.models.Conference conference = this.getConference();
        if (null == media || conference == null) {
            return false;
        }
        return this.getLevel(participant) > 0.001;
    }

    @NonNull
    private String currentParticipantOrEmpty() {
        return (String)Opt.of((Object)VoxeetSdk.session()).then(SessionService::getParticipantId).or((Object)"");
    }

    @Nullable
    public Participant findParticipantById(String participantId) {
        return (Participant)Opt.of((Object)this.getConference()).then(c -> c.findParticipantById(participantId)).orNull();
    }

    @NoDocumentation
    @Nullable
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @Deprecated
    @NoDocumentation
    public boolean muteParticipant(@NonNull String participantId, boolean shouldMute) {
        return false;
    }

    private boolean isVideoOn() {
        ConferenceInformation information = this.getCurrentConference();
        return null != information && information.isOwnVideoStarted();
    }

    @Deprecated
    @NoDocumentation
    public boolean setParticipantPosition(String participantId, double angle, double distance) {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            ConferenceInformation conference = this.getCurrentConference();
            if (null != conference) {
                ParticipantPosition position = conference.getPosition(participantId);
                position.angle = angle;
                position.distance = distance;
                conference.setPosition(participantId, position);
            }
            media.changePeerPosition(participantId, angle, distance);
            return true;
        }
        return false;
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        return (LocalConferenceType)((Object)Opt.of((Object)this.getCurrentConference()).then(ConferenceInformation::getConferenceType).or((Object)LocalConferenceType.NONE));
    }

    @Nullable
    public com.voxeet.sdk.models.Conference getConference() {
        ConferenceInformation information = this.getCurrentConference();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    @NoDocumentation
    void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    @NoDocumentation
    public double getLevel(@Nullable String participantId) {
        Validate.runningOnUiThread();
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null == media || null == participantId) {
            return 0.0;
        }
        double peerVuMeter = media.getPeerVuMeter(participantId);
        if (Double.isNaN(peerVuMeter)) {
            peerVuMeter = 0.0;
        }
        return peerVuMeter;
    }

    public double getLevel(@Nullable Participant participant) {
        if (null != participant && participant.getId() != null && !participant.getId().equals(VoxeetPreferences.id()) && participant.isLocallyActive()) {
            return this.getLevel(participant.getId());
        }
        return 0.0;
    }

    @NoDocumentation
    @NonNull
    public List<Participant> getParticipants() {
        return (List)Opt.of((Object)this.getConference()).then(com.voxeet.sdk.models.Conference::getParticipants).or(new CopyOnWriteArrayList());
    }

    @NoDocumentation
    @NonNull
    public List<Participant> getLastInvitationParticipants() {
        return (List)Opt.of((Object)this.getCurrentConference()).then(ConferenceInformation::getLastInvitationReceived).or(new ArrayList());
    }

    @NoDocumentation
    public boolean isLive() {
        return null != this.getConference();
    }

    @NonNull
    public ConferenceService cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    @NonNull
    public Promise<Boolean> decline(String conferenceId) {
        return new DeclinePromise(this, VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId).createPromise();
    }

    @NoDocumentation
    void onParticipantCanceledScreenShare() {
        ConferenceInformation information;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            media.stopScreenCapturer();
        }
        if (null != (information = this.getCurrentConference())) {
            information.setScreenShareOn(false);
        }
    }

    @NonNull
    public Promise<Boolean> startVideo() {
        CameraContext provider = VoxeetSdk.mediaDevice().getCameraContext();
        return this.startVideo(provider.isDefaultFrontFacing());
    }

    @NoDocumentation
    @NonNull
    public Promise<Boolean> startVideo(boolean isDefaultFrontFacing) {
        return new StartVideoPromise(this, VoxeetSdk.mediaDevice(), this.videoAccess, this.getCurrentConference(), this.getEventBus(), isDefaultFrontFacing, this.mConferenceInformationHolder).createPromise();
    }

    @NonNull
    public Promise<Boolean> stopVideo() {
        return new StopVideoPromise(this, VoxeetSdk.mediaDevice(), this.videoAccess, this.getCurrentConference(), this.getEventBus(), this.mConferenceInformationHolder).createPromise();
    }

    @NoDocumentation
    Promise<Boolean> createVideoAnswer(@NonNull String participantId, @Nullable OfferDescription offerDescription, List<OfferCandidate> offerCandidates) {
        return new Promise(solver -> {
            MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
            String sdp = "";
            String type = "";
            if (null != offerDescription) {
                sdp = offerDescription.sdp;
                type = offerDescription.type;
            }
            if (null == media) {
                Promise.reject((Solver)solver, (Throwable)new MediaEngineException("media is null"));
                return;
            }
            if (null == offerDescription) {
                this.stopVideo().execute();
                Log.d((String)TAG, (String)"onCall: unable to start video, are you a listener?");
                solver.resolve((Object)false);
                return;
            }
            SdpDescription description = new SdpDescription(type, sdp);
            ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
            if (offerCandidates != null) {
                for (OfferCandidate candidate : offerCandidates) {
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
            }
            this.createAnswerForPeerThreaded(media, participantId, description.ssrc, description, candidates, participantId.equals(VoxeetSdk.session().getParticipantId())).then(message -> this.answer(participantId, (SdpMessage)message)).then(result -> solver.resolve((Object)true)).error(error -> {
                if (error instanceof ParticipantAddedErrorEventException) {
                    this.mEventBus.post((Object)((ParticipantAddedErrorEventException)error).event);
                } else {
                    error.printStackTrace();
                }
                solver.resolve((Object)false);
            });
        });
    }

    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias) {
        return this.create(new ConferenceCreateOptions.Builder().setConferenceAlias(conferenceAlias).build());
    }

    @Deprecated
    @NoDocumentation
    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder paramsholder) {
        return this.create(new ConferenceCreateOptions.Builder().setConferenceAlias(conferenceAlias).setMetadataHolder(metadata).setParamsHolder(paramsholder).build());
    }

    @NonNull
    public Promise<CreateConferenceResult> create(@NonNull ConferenceCreateOptions conferenceCreateOptions) {
        return new CreateConferencePromiseable(this, VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getCurrentConference(), this.getEventBus(), conferenceCreateOptions.getConferenceAlias(), conferenceCreateOptions.getMetadataHolder(), conferenceCreateOptions.getParamsHolder()).createPromise();
    }

    public Promise<com.voxeet.sdk.models.Conference> listen(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceParticipantType(ConferenceParticipantType.LISTENER).build());
    }

    public Promise<com.voxeet.sdk.models.Conference> broadcast(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceParticipantType(ConferenceParticipantType.BROADCASTER).build());
    }

    @NonNull
    public Promise<com.voxeet.sdk.models.Conference> join(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceParticipantType(ConferenceParticipantType.NORMAL).build());
    }

    private Promise<com.voxeet.sdk.models.Conference> join(@NonNull ConferenceJoinInformation conferenceJoinInformation) {
        String id = (String)Opt.of((Object)conferenceJoinInformation).then(ConferenceJoinInformation::getConferenceId).or((Object)"");
        return new JoinPromise(this, VoxeetSdk.audio(), VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getConferenceInformation(id), this.getEventBus(), this.getVoxeetSDK(), id, conferenceJoinInformation.getConferenceParticipantType()).createPromise();
    }

    @NoDocumentation
    public Promise<com.voxeet.sdk.models.Conference> demo() {
        return new Promise(solver -> HttpHelper.promise(this.conferenceAccess.demo(), ServerErrorOrigin.UNDEFINED).then(answer -> {
            CreateConferenceResult object = (CreateConferenceResult)answer.object;
            return this.listen((String)Opt.of((Object)object).then(s -> s.conferenceId).or((Object)""));
        }).then(arg_0 -> ((Solver)solver).resolve(arg_0)).error(error -> Promise.reject((Solver)solver, (Throwable)((Throwable)Opt.of((Object)error).or((Object)new IllegalStateException())))));
    }

    @NoDocumentation
    @NonNull
    public Promise<List<Participant>> invite(String conferenceId, List<ParticipantInfo> participantOptions) {
        return new Promise(solver -> {
            List<Participant> participants = this.getParticipants();
            ArrayList<String> strings = new ArrayList<String>();
            if (null != participantOptions) {
                for (ParticipantInfo info : participantOptions) {
                    if (null == info || info.getExternalId() == null) continue;
                    String participantInfoId = (String)Opt.of((Object)info).then(ParticipantInfo::getExternalId).orNull();
                    for (Participant participant : participants) {
                        String arrayId = (String)Opt.of((Object)participant).then(Participant::getInfo).then(ParticipantInfo::getExternalId).orNull();
                        if (null == arrayId || !arrayId.equalsIgnoreCase(participantInfoId)) continue;
                        participant.updateIfNeeded(info.getName(), info.getAvatarUrl());
                    }
                    strings.add(info.getExternalId());
                }
            }
            solver.resolve(new InvitePromise(this, VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getCurrentConference(), this.getEventBus(), conferenceId, strings).createPromise());
        });
    }

    @NonNull
    public Promise<com.voxeet.sdk.models.Conference> replay(String conferenceId, long offset) {
        return new ReplayPromise(this, VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, offset).createPromise();
    }

    @NonNull
    public Promise<ConferenceStatusResult> getConferenceStatus(String conferenceId) {
        return new GetConferenceStatusPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<ConferenceHistoryResult> conferenceHistory(String conferenceId) {
        return new GetConferenceHistoryPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> subscribe(@NonNull String conferenceId) {
        return new SubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> unSubscribe(@NonNull String conferenceId) {
        return new UnsubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> subscribeForCall(String conferenceId) {
        return new SubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> unSubscribeFromCall(String conferenceId) {
        return new UnsubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(PushConferenceDestroyed event) {
        EventBus.getDefault().post((Object)new ConferenceDestroyedPush(event.conferenceId));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull OwnConferenceParticipantSwitch switchEvent) {
        Log.d((String)TAG, (String)("onEvent: OwnConferenceParticipantSwitch : type ? " + switchEvent.getType()));
        if (this.isLive()) {
            this.leave().then(result -> Log.d((String)TAG, (String)"onCall: on leave for switch participant")).error(error -> Log.d((String)TAG, (String)"onError: on leave for switch participant"));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull SocketStateChangeEvent event) {
        if (WebSocketState.CONNECTED.equals((Object)event.state)) {
            String conferenceId = this.getConferenceId();
            ConferenceInformation information = this.getCurrentConference();
            if (null != conferenceId && null != information && ConferenceStatus.JOINED.equals((Object)information.getConferenceState())) {
                if (this.ConferenceConfigurations.isICERestartEnabled) {
                    Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined <3");
                    Call<ResponseBody> participant = this.mediaAccess.iceRestart(conferenceId);
                    HttpHelper.enqueue(participant, (response, object, exception) -> {
                        if (null != exception) {
                            Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined error </3");
                            HttpException.dumpErrorResponse(response);
                        } else {
                            Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined responded <3");
                        }
                    });
                } else {
                    Log.d((String)TAG, (String)"onEvent: socket state opened while in conference but no isICERestartEnabled() = true. A reconnect may be longer");
                }
            } else {
                ConferenceStatus state = ConferenceStatus.DEFAULT;
                if (null != information) {
                    state = information.getConferenceState();
                }
                Log.d((String)TAG, (String)("onEvent: SocketConnectEvent not rejoined </3 " + (Object)((Object)state) + " " + conferenceId));
            }
        }
    }

    @NoDocumentation
    void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        boolean canOverride;
        String conferenceId = conference.getConference().getId();
        boolean invalidId = null == conferenceId;
        boolean inConference = this.isInConference();
        boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
        boolean bl = canOverride = !inConference || sameConference;
        if (!invalidId && canOverride) {
            this.mConferenceId = conferenceId;
        }
    }

    @NonNull
    @NoDocumentation
    Promise<com.voxeet.sdk.models.Conference> joinConferenceInternalPackage(@NonNull ConferenceInformation conference) {
        return new Promise(solver -> {
            String conferenceId = conference.getConference().getId();
            boolean inConference = this.isInConference();
            boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
            this.removeTimeoutCallbacks();
            Log.d((String)TAG, (String)("joining " + conferenceId));
            this.setIsInConference(true);
            this.mConferenceId = conferenceId;
            conference.setConferenceState(ConferenceStatus.JOINING);
            AudioService service = VoxeetSdk.audio();
            service.enableAec(true);
            service.enableNoiseSuppressor(true);
            boolean isSuccess = this.initMedia(conference.isListener());
            com.voxeet.sdk.models.Conference correspondingConference = conference.getConference();
            if (!isSuccess) {
                Log.d((String)TAG, (String)"onCall: InitMedia failed... new state = left");
                try {
                    this.setIsInConference(false);
                    conference.setConferenceState(ConferenceStatus.LEFT);
                    this.closeMedia();
                    ConferenceStatusUpdatedEvent error = new ConferenceStatusUpdatedEvent(correspondingConference, correspondingConference.getState());
                    this.mEventBus.post((Object)error);
                    throw new MediaEngineException("onCall: InitMedia failed... new state = left");
                }
                catch (MediaEngineException exception2) {
                    solver.reject((Throwable)exception2);
                    return;
                }
            }
            this.mEventBus.post((Object)new ConferenceStatusUpdatedEvent(correspondingConference, correspondingConference.getState()));
            Call<ResumeConference> participant = this.conferenceAccess.join(conferenceId, new JoinParameters(DeviceType.ANDROID, conference.isListener()));
            HttpHelper.enqueue(participant, (response, object, exception) -> {
                if (null != object) {
                    this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                    this.initMedia(conference.isListener());
                    String automaticTelecomModePrefix = this.ConferenceConfigurations.automaticTelecomModePrefix;
                    boolean hasAutomaticPrefix = null != automaticTelecomModePrefix && !TextUtils.isEmpty((CharSequence)automaticTelecomModePrefix);
                    Log.d((String)TAG, (String)("onSuccess: trying to join conference, will an attempt to be telecom be made ? " + hasAutomaticPrefix));
                    ConferenceInformation information = this.getCurrentConference();
                    if (null != information) {
                        if (hasAutomaticPrefix && !TextUtils.isEmpty((CharSequence)object.getConferenceAlias()) && object.getConferenceAlias().startsWith(automaticTelecomModePrefix)) {
                            Log.d((String)TAG, (String)"onSuccess: the conference is now in telecom mode");
                            information.setTelecomMode(true);
                        } else {
                            Log.d((String)TAG, (String)"onSuccess: the prefix does not match - if the telecom mode is required, it must be done programmatically at this point");
                        }
                        information.setConferenceState(ConferenceStatus.JOINED);
                    }
                    solver.resolve(this.onConferenceResumedInternal((ResumeConference)object));
                } else {
                    this.setIsInConference(false);
                    com.voxeet.sdk.models.Conference correspondingConference1 = conference.getConference();
                    conference.setConferenceState(ConferenceStatus.ERROR);
                    this.closeMedia();
                    ConferenceStatusUpdatedEvent event = new ConferenceStatusUpdatedEvent(correspondingConference1, correspondingConference1.getState());
                    this.getEventBus().post((Object)event);
                    if (exception instanceof HttpException) {
                        Promise.reject((Throwable)new ServerErrorException(((HttpException)exception).error, ServerErrorOrigin.JOIN));
                    } else {
                        solver.reject(exception);
                    }
                }
            });
        });
    }

    @NonNull
    public Promise<Boolean> simulcast(@NonNull List<ParticipantQuality> requested) {
        return new SimulcastPromiseable(this, VoxeetSdk.mediaDevice(), this.simulcastAccess, this.getCurrentConference(), this.getEventBus(), requested).createPromise();
    }

    @NonNull
    private Promise<com.voxeet.sdk.models.Conference> onConferenceResumedInternal(@NonNull ResumeConference response) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConference();
        if (null == information) {
            return Promise.reject((Throwable)new NotInConferenceException());
        }
        com.voxeet.sdk.models.Conference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        information.participantsToConferenceParticipants(response.getParticipants());
        this.setIsInConference(true);
        VoxeetSdk.audio().setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.mEventBus.post((Object)new ConferenceStatusUpdatedEvent(conference, conference.getState()));
        List<RestParticipant> participants = response.getParticipants();
        int length = null != participants ? participants.size() : -1;
        Log.d((String)TAG, (String)("onConferenceResumedInternal: resuming with participants ? " + participants + " " + length));
        if (null != participants) {
            for (RestParticipant participant : participants) {
                Log.d((String)TAG, (String)("onConferenceResumedInternal: call onParticipantAddedOrUpdated " + participant));
                this.onParticipantAddedOrUpdated(conference.getId(), participant.getParticipantId(), participant.getParticipantInfo(), ConferenceParticipantStatus.fromString(participant.getStatus()), true);
            }
        }
        if (null == response.getCandidates() && null == response.getDescription()) {
            Log.d((String)TAG, (String)"onConferenceResumedInternal: candidates + description");
            return Promise.resolve((Object)conference);
        }
        Log.d((String)TAG, (String)"onConferenceResumedInternal: having candidates and description");
        ParticipantInfo info = VoxeetSdk.session().getParticipantInfo();
        String name = null;
        String externalId = null;
        String avatarUrl = null;
        String participantId = "";
        if (null != info) {
            participantId = (String)Opt.of((Object)VoxeetSdk.session()).then(SessionService::getParticipantId).or((Object)"");
            name = info.getName();
            externalId = info.getExternalId();
            avatarUrl = info.getAvatarUrl();
        }
        return this.handleAnswer(response.getConferenceId(), participantId, externalId, name, avatarUrl, "ANDROID", true, response.getDescription(), response.getCandidates());
    }

    @NonNull
    public Promise<ConferenceParticipantsInvitedResult> getInvitedParticipants(@NonNull String conferenceId) {
        return new GetConferenceStatus(this, VoxeetSdk.mediaDevice(), this.outConferenceAccess, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NonNull
    public Promise<Boolean> leave() {
        return new LeavePromise(this, VoxeetSdk.mediaDevice(), this.conferenceAccess, this.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = (String)Opt.of((Object)invitation.conferenceId).orNull();
        if (null == conferenceId && null != invitation.conference) {
            conferenceId = (String)Opt.of((Object)invitation.conference).then(Conference::getConferenceId).orNull();
        }
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        ConferenceInformation information = this.getConferenceInformation((String)Opt.of((Object)conferenceId).or((Object)""));
        boolean is_own_participant = invitation.participantId.equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(invitation.conference.getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_participant || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.ParticipantInviter inviter = invitation.getInviter();
            List<Invitation> invitations = invitation.invitations;
            Participant[] foundParticipant = new Participant[]{null};
            if (null != inviter && null != inviter.externalId && null != inviter.participantId) {
                try {
                    Participant inviter_participant;
                    ParticipantInfo info = new ParticipantInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                    foundParticipant[0] = inviter_participant = new Participant(inviter.participantId, info);
                    information.getLastInvitationReceived().add(inviter_participant);
                    information.getParticipantIdsCached().put(inviter.participantId, inviter.externalId);
                }
                catch (Exception exception) {}
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            this.getConferenceStatus(invitation.conference.getConferenceId()).then((result, internal_solver) -> {
                List participants = (List)Opt.of((Object)result).then(ConferenceStatusResult::getConferenceUsers).or(new ArrayList());
                if (participants.size() > 0) {
                    Log.d((String)TAG, (String)("onEvent: participants " + participants.size()));
                    try {
                        String foundExternalId = null;
                        ArrayList<Participant> merged_list = new ArrayList<Participant>();
                        for (SdkParticipant participant : (List)Opt.of((Object)result).then(r -> r.participants).or(new ArrayList())) {
                            merged_list.add(new Participant(participant));
                        }
                        merged_list.addAll(this.getLastInvitationParticipants());
                        List<Participant> list = ConferenceUtils.findParticipantsMatching(this.currentParticipantOrEmpty(), merged_list);
                        for (Participant conferenceParticipant : list) {
                            String participantId = conferenceParticipant.getId();
                            if (null != foundExternalId) continue;
                            String externalId = (String)Opt.of((Object)conferenceParticipant).then(Participant::getInfo).then(ParticipantInfo::getExternalId).orNull();
                            String cachedExternalId = information.getParticipantIdsCached().get(participantId);
                            Log.d((String)TAG, (String)("onEvent: " + participantId + " " + externalId + " " + cachedExternalId));
                            if (null == foundParticipant[0]) {
                                foundParticipant[0] = conferenceParticipant;
                            }
                            if (null == participantId || null != externalId && !participantId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    HashMap<String, Object> infos = new HashMap<String, Object>();
                    infos.put("UserId", Opt.of((Object)foundParticipant[0]).then(Participant::getId).or((Object)""));
                    infos.put("DisplayName", Opt.of((Object)foundParticipant[0]).then(Participant::getInfo).then(ParticipantInfo::getName).or((Object)""));
                    infos.put("NotifType", Opt.of((Object)result).then(ConferenceStatusResult::getType).or((Object)""));
                    infos.put("ExternalId", Opt.of((Object)foundParticipant[0]).then(Participant::getInfo).then(ParticipantInfo::getExternalId).or((Object)""));
                    infos.put("AvatarUrl", Opt.of((Object)foundParticipant[0]).then(Participant::getInfo).then(ParticipantInfo::getAvatarUrl).or((Object)""));
                    infos.put("ConfId", Opt.of((Object)result).then(r -> r.conferenceId).or((Object)""));
                    VoxeetSdk.notification().onInvitationReceived(this.context, new InvitationBundle(infos));
                    this.mEventBus.post((Object)new IncomingCallEvent((String)Opt.of((Object)result).then(r -> r.conferenceId).or((Object)"")));
                }
            }).error(Throwable::printStackTrace);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceCreated ownConferenceStartedEvent) {
        com.voxeet.sdk.models.Conference conference;
        if (null != ownConferenceStartedEvent.conferenceInfos) {
            this.mConferenceId = ownConferenceStartedEvent.conferenceInfos.getConferenceId();
        }
        if (null != (conference = this.getConference())) {
            conference.setConferenceInfos(ownConferenceStartedEvent.conferenceInfos);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationEndedEvent event) {
        Log.d((String)TAG, (String)("onEvent: Renegociation " + event.getConferenceId() + " " + event.getType() + " " + event.getAnswerReceived() + " " + event.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OfferCreated offer) {
        String conferenceId;
        com.voxeet.sdk.models.Conference conference = this.getConference();
        String string = conferenceId = null != conference ? conference.getId() : null;
        if (null != conferenceId && conferenceId.equals(offer.getConferenceId())) {
            Participant participant = this.findParticipantById(offer.getParticipantId());
            if (null == participant) {
                participant = new Participant(offer.getParticipantId(), new ParticipantInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl()));
                Log.d((String)TAG, (String)("run: WARNING obtained OfferCreated for participant which did not existed " + participant));
                conference.updateParticipant(participant);
                this.mEventBus.post((Object)new ParticipantAddedEvent(conference, participant));
            }
            this.handleAnswer(offer.getConferenceId(), offer.getParticipantId(), offer.getExternalId(), offer.getName(), offer.getAvatarUrl(), offer.getDevice(), offer.isMaster(), offer.getDescription(), offer.getCandidates()).then(conf -> Log.d((String)TAG, (String)("onCall: answer called, result is " + conf + " " + offer.getParticipantId() + " " + VoxeetPreferences.id()))).error(error -> {
                error.printStackTrace();
                ExceptionManager.sendException(error);
            });
        } else {
            Log.d((String)TAG, (String)"onEvent: OfferCreated for another conference");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAdded event) {
        this.onParticipantAddedOrUpdated(event.conferenceId, event.participantId, new ParticipantInfo(event.name, event.externalId, event.avatarUrl), ConferenceParticipantStatus.fromString(event.status), true);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdated event) {
        this.onParticipantAddedOrUpdated(event.conferenceId, event.participantId, null, ConferenceParticipantStatus.valueOf(event.status), false);
    }

    private void onParticipantAddedOrUpdated(@NonNull String conferenceId, @NonNull String participantId, @Nullable ParticipantInfo participantInfo, @NonNull ConferenceParticipantStatus status, boolean added) {
        boolean timeout_triggered;
        String id = VoxeetSdk.session().getParticipantId();
        if (null == id) {
            return;
        }
        boolean known_participant = false;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        com.voxeet.sdk.models.Conference conference = information.getConference();
        Participant participant = conference.findParticipantById(participantId);
        if (null != participant) {
            known_participant = true;
            if (added && null != participantInfo) {
                participant.setParticipantInfo(participantInfo);
            }
            participant.updateStatus(status);
        } else {
            participant = new Participant(participantId, participantInfo);
            conference.updateParticipant(participant);
        }
        this.updateConferenceFromParticipants();
        switch (status) {
            case CONNECTING: {
                if (id.equals(participant.getId())) break;
                Log.d((String)TAG, (String)"Cancelling timeout timer from participant connecting");
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (null == media) break;
                participant.streamsHandler().removeAllStreams();
                Log.d((String)TAG, (String)("In mConference participant with id: " + participant + " status updated to " + (Object)((Object)status)));
                media.removePeer(participantId);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("status not managed updated to " + (Object)((Object)status)));
            }
        }
        boolean bl = timeout_triggered = null != this.timeoutRunnable && this.timeoutRunnable.isTriggered();
        if (!timeout_triggered) {
            switch (status) {
                case DECLINE: {
                    if (!participantId.equals(VoxeetSdk.session().getParticipantId())) {
                        Log.d((String)TAG, (String)("Conference participant with id: " + participantId + " declined the call"));
                        this.checkForTelecomEvent(conferenceId, participantId);
                        this.mEventBus.post((Object)new ParticipantUpdatedEvent(conference, participant));
                        break;
                    }
                }
                case LEFT: {
                    this.checkForTelecomEvent(conference.getId(), participant.getId());
                }
                default: {
                    this.updateConferenceFromParticipants();
                    if (known_participant) {
                        this.mEventBus.post((Object)new ParticipantUpdatedEvent(conference, participant));
                        break;
                    }
                    this.mEventBus.post((Object)new ParticipantAddedEvent(conference, participant));
                }
            }
        }
    }

    private void checkForTelecomEvent(String conferenceId, String participantId) {
        ConferenceInformation currentConference = this.getCurrentConference();
        Log.d((String)TAG, (String)("checkForTelecomEvent: having currentConference ? " + currentConference));
        if (null != currentConference && currentConference.isTelecomMode()) {
            com.voxeet.sdk.models.Conference conference = currentConference.getConference();
            if (null != conferenceId && conferenceId.equals(conference.getId())) {
                String id = VoxeetPreferences.id();
                if (!TextUtils.isEmpty((CharSequence)participantId) && null != id && !id.equals(participantId)) {
                    this.leave().then(result -> Log.d((String)TAG, (String)"onCall: conference left since declined/left event")).error(error -> Log.e((String)TAG, (String)"onError: conference left since declined/left event", (Throwable)error));
                }
            }
        } else {
            Log.d((String)TAG, (String)"checkForTelecomEvent: not a telecom mode");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceDestroyedPush event) {
        this.onEndOrDestroyed(event.conferenceId, ConferenceStatus.DESTROYED);
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceEnded event) {
        this.onEndOrDestroyed(event.conferenceId, ConferenceStatus.ENDED);
    }

    private void onEndOrDestroyed(@Nullable String eventConfId, ConferenceStatus newStatus) {
        String conferenceId = this.mConferenceId;
        ConferenceInformation information = this.getCurrentConference();
        if (null != information && !TextUtils.isEmpty((CharSequence)information.getConference().getId())) {
            conferenceId = information.getConference().getId();
        }
        if (null != information && !TextUtils.isEmpty((CharSequence)conferenceId) && conferenceId.equals(eventConfId)) {
            information.setConferenceState(newStatus);
            this.closeMedia();
            this.mEventBus.post((Object)new ConferenceStatusUpdatedEvent(information.getConference(), newStatus));
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdated event) {
        for (ConferenceUser conferenceParticipant : event.participants) {
            Participant participant = this.findParticipantById(conferenceParticipant.getUserId());
            if (participant == null) continue;
            participant.setQuality(conferenceParticipant.getQuality());
            this.mEventBus.post((Object)new ConferenceParticipantQualityUpdatedEvent(participant));
        }
    }

    @NoDocumentation
    @NonNull
    protected Participant createParticipant(String participantId, String device, ParticipantInfo participantInfo) {
        return new Participant(participantId, participantInfo);
    }

    @NoDocumentation
    protected void setConference(@NonNull com.voxeet.sdk.models.Conference conference) {
        this.mConferenceId = conference.getId();
        ConferenceInformation information = this.getCurrentConference();
        if (null != information) {
            information.setConference(conference);
        }
    }

    @NoDocumentation
    protected void setConferenceAlias(String alias) {
        com.voxeet.sdk.models.Conference conference = this.getConference();
        if (null != conference) {
            conference.setConferenceAlias(alias);
        }
    }

    @NoDocumentation
    protected boolean isSDK() {
        return true;
    }

    @NoDocumentation
    protected Promise<Integer> answer(String peer, SdpMessage message) {
        return new Promise(solver -> {
            if (null == this.mConferenceId) {
                Promise.reject((Solver)solver, (Throwable)new NotInConferenceException());
                return;
            }
            if (null == message) {
                Promise.reject((Throwable)new ParticipantAddedErrorEventException(new ParticipantAddedErrorEvent("Invalid message")));
                return;
            }
            Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
            Call<ResponseBody> call = this.mediaAccess.answerConference(this.mConferenceId, peer, message.getDescription());
            HttpHelper.enqueue(call, (response, object, exception) -> {
                int code = (Integer)Opt.of((Object)response).then(Response::code).or((Object)0);
                if (null != exception) {
                    HttpException.dumpErrorResponse(response);
                    Promise.reject((Solver)solver, (Throwable)new ParticipantAddedErrorEventException(new ParticipantAddedErrorEvent(this.handleError(exception))));
                } else if (200 != code) {
                    Promise.reject((Solver)solver, (Throwable)new ParticipantAddedErrorEventException(new ParticipantAddedErrorEvent(code + "")));
                } else {
                    solver.resolve((Object)code);
                }
            });
        });
    }

    @NoDocumentation
    private Promise<com.voxeet.sdk.models.Conference> handleAnswer(@NonNull String conferenceId, @NonNull String participantId, @Nullable String externalId, @Nullable String name, @Nullable String avatarUrl, @NonNull String device, boolean isMaster, @NonNull OfferDescription offerDescription, @NonNull List<OfferCandidate> offerCandidates) {
        return new Promise(solver -> {
            MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
            if (null == media) {
                Promise.reject((Solver)solver, (Throwable)new MediaEngineException("handleAnswer media is null"));
                return;
            }
            ConferenceInformation conferenceInformation = this.getConferenceInformation(conferenceId);
            com.voxeet.sdk.models.Conference conference = conferenceInformation.getConference();
            if (!conferenceId.equals(this.mConferenceId)) {
                Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
            }
            SdpDescription description = new SdpDescription(offerDescription.type, offerDescription.sdp);
            ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
            for (OfferCandidate candidate : offerCandidates) {
                Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
            }
            Log.d((String)TAG, (String)("handleAnswer: offer := " + participantId + " " + externalId));
            Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + participantId + " " + externalId + " " + description.ssrc));
            com.voxeet.sdk.models.Conference conference1 = this.getConference();
            this.createAnswerForPeerThreaded(media, participantId, description.ssrc, description, candidates, isMaster).then(message -> {
                if (null == this.mConferenceId) {
                    Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                    this.mConferenceId = conferenceId;
                }
                Participant participant = null;
                for (Participant in_conf : conference1.getParticipants()) {
                    if (in_conf.getId() == null || !in_conf.getId().equals(participantId)) continue;
                    participant = in_conf;
                }
                ParticipantInfo infos = ParticipantUtils.createParticipantInfo(participantId, name, externalId, avatarUrl);
                if (participant == null) {
                    participant = new Participant(participantId, infos);
                    conference1.updateParticipant(participant);
                } else {
                    participant.setParticipantInfo(infos);
                }
                this.setParticipantPosition(participantId, 0.0, 0.5);
                return this.answer(participantId, (SdpMessage)message);
            }).then(result -> {
                Log.d((String)TAG, (String)("onSuccess: " + result));
                solver.resolve((Object)conference1);
            }).error(error -> {
                if (error instanceof ParticipantAddedErrorEventException) {
                    this.mEventBus.post((Object)((ParticipantAddedErrorEventException)error).event);
                } else {
                    error.printStackTrace();
                }
                solver.reject(error);
            });
        });
    }

    @NoDocumentation
    protected Participant updateConferenceParticipants(String participantId, ConferenceParticipantStatus status) {
        Participant participant = this.findParticipantById(participantId);
        com.voxeet.sdk.models.Conference conference = this.getConference();
        if (null != participant && null != conference) {
            participant.updateStatus(status);
            return participant;
        }
        return null;
    }

    @NoDocumentation
    protected boolean initMedia(boolean listenerMode) {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "participant id");
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null == media) {
            try {
                if (!listenerMode && !Validate.hasMicrophonePermissions(this.context)) {
                    Log.d((String)TAG, (String)"the app does not seem to have mic permission, disabling mic");
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                AudioService audioService = VoxeetSdk.audio();
                MediaDeviceService mediaDeviceService = VoxeetSdk.mediaDevice();
                audioService.enable();
                mediaDeviceService.createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.cameraEventsHandler, this.ConferenceConfigurations.isDefaultVideo || this.isVideoOn(), !listenerMode && Validate.hasMicrophonePermissions(this.context));
                media = mediaDeviceService.getMedia();
                audioService.unsetMediaRoute().requestAudioFocus();
                audioService.checkDevicesToConnectOnConference(this.ConferenceConfigurations.isDefaultOnSpeaker);
                if (null != media) {
                    if (this.ConferenceConfigurations.isDefaultMute) {
                        media.mute();
                    } else {
                        media.unMute();
                    }
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return false;
            }
            catch (MediaEngineException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @NoDocumentation
    protected void closeMedia() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            com.voxeet.sdk.models.Conference conference = this.getConference();
            ConferenceInformation information = this.getCurrentConference();
            if (null != information) {
                this.mConferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                information.setRequestedOwnVideo(false);
                information.setScreenShareOn(false);
                information.setConferenceState(ConferenceStatus.LEFT);
            }
            try {
                for (Participant participant : (CopyOnWriteArrayList)Opt.of((Object)conference).then(com.voxeet.sdk.models.Conference::getParticipants).or(new CopyOnWriteArrayList())) {
                    if (participant == null || participant.getId() == null) continue;
                    media.removePeer(participant.getId());
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Error", (Throwable)ex);
            }
            VoxeetSdk.audio().abandonAudioFocusRequest().setMediaRoute().disable();
            VoxeetSdk.mediaDevice().releaseMedia();
            media.unsetStreamListener();
        }
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    @NoDocumentation
    protected void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    @NoDocumentation
    protected void sendTimeoutCallbacks() {
        if (this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.mEventBus, this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout);
        }
    }

    @NonNull
    @NoDocumentation
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + conferenceId));
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        com.voxeet.sdk.models.Conference conference = information.getConference();
        conference.setConferenceId(conferenceId);
        if (null != conferenceAlias || null == conference.getAlias()) {
            conference.setConferenceAlias(conferenceAlias);
        }
        return information;
    }

    @Nullable
    public ConferenceInformation getCurrentConference() {
        if (null == this.mConferenceId) {
            return null;
        }
        return this.getConferenceInformation(this.mConferenceId);
    }

    public boolean hasParticipants() {
        com.voxeet.sdk.models.Conference conference = this.getConference();
        if (null == conference) {
            return false;
        }
        if (conference.hasLocalStreams(false)) {
            return true;
        }
        return conference.hasAny(ConferenceParticipantStatus.ON_AIR, false);
    }

    @NonNull
    @NoDocumentation
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    public ConferenceInformation getConferenceInformation(@NonNull String conferenceId) {
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    @NoDocumentation
    void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NoDocumentation
    void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConferenceFromParticipants() {
        ConferenceInformation information = this.getCurrentConference();
        if (Opt.isNonNull((Object[])new Object[]{information})) {
            ConferenceStatus state = (ConferenceStatus)((Object)Opt.of((Object)information).then(ConferenceInformation::getConferenceState).or((Object)ConferenceStatus.DEFAULT));
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceStatus.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceStatus.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceStatus.FIRST_PARTICIPANT);
                    break;
                }
            }
        }
    }

    @NoDocumentation
    void clearConferencesInformation() {
        this.mConferenceInformationHolder.clearConferencesInformation();
    }

    @NoDocumentation
    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        Log.d((String)TAG, (String)("moveConference: change " + conferenceInformation.getConference().getId() + " to " + conferenceId));
        this.mConferenceInformationHolder.moveConference(conferenceId, conferenceInformation);
    }

    private Promise<SdpMessage> createAnswerForPeerThreaded(@NonNull MediaSDK media, @NonNull String participantId, long ssrc, @NonNull SdpDescription offer, @NonNull List<SdpCandidate> candidates, boolean master) {
        return new Promise(solver -> this.executorService.submit(() -> {
            if (!Opt.isNonNull((Object[])new Object[]{media})) {
                Promise.reject((Solver)solver, (Throwable)new MediaEngineException("MediaEngine is null in createAnswerForPeerThreaded"));
                return;
            }
            try {
                media.createAnswerForPeer(participantId, ssrc, offer, candidates, master, arg_0 -> ((Solver)solver).resolve(arg_0));
            }
            catch (MediaEngineException e) {
                e.printStackTrace();
                solver.reject((Throwable)e);
            }
        }));
    }
}

