/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.promise.Promise;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.models.v1.ConferenceParticipantStatus;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.Opt;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Response;

public abstract class AbstractPromiseable<PROMISE_RETURN_TYPE, API_REST_CALL> {
    private final API_REST_CALL provider;
    private final ConferenceInformation information;
    private final EventBus eventBus;
    @NonNull
    private MediaDeviceService mediaDeviceService;
    @NonNull
    private ConferenceService parent;

    protected AbstractPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull API_REST_CALL provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        this.parent = parent;
        this.mediaDeviceService = mediaDeviceService;
        this.provider = provider;
        this.information = information;
        this.eventBus = eventBus;
    }

    @NonNull
    protected ConferenceService getParent() {
        return this.parent;
    }

    @NonNull
    protected MediaDeviceService getMediaService() {
        return this.mediaDeviceService;
    }

    @NonNull
    protected API_REST_CALL getApiRestCall() {
        return this.provider;
    }

    @Nullable
    protected ConferenceInformation getInformation() {
        if (null != this.information) {
            return this.information;
        }
        return this.parent.getCurrentConference();
    }

    @NonNull
    protected EventBus getEventBus() {
        return this.eventBus;
    }

    protected boolean isInConference() {
        return this.getParent().isInConference();
    }

    protected boolean hasMedia() {
        return this.getMediaService().hasMedia();
    }

    @Nullable
    protected MediaSDK getMedia() {
        return this.getMediaService().getMedia();
    }

    @NonNull
    public abstract Promise<PROMISE_RETURN_TYPE> createPromise();

    protected void log(@NonNull String log) {
        if (!TextUtils.isEmpty((CharSequence)log)) {
            Log.d((String)this.getClass().getSimpleName(), (String)log);
        }
    }

    protected void setIsInConference(boolean status) {
        this.getParent().setIsInConference(status);
    }

    protected Promise<Boolean> createVideoAnswer(String participantId, OfferDescription offerDescription, List<OfferCandidate> offerCandidates) {
        return this.getParent().createVideoAnswer(participantId, offerDescription, offerCandidates);
    }

    protected boolean isSDK() {
        return this.getParent().isSDK();
    }

    protected Participant updateConferenceParticipants(String participantId, ConferenceParticipantStatus status) {
        return this.getParent().updateConferenceParticipants(participantId, status);
    }

    protected void closeMedia() {
        this.getParent().closeMedia();
    }

    protected void removeTimeoutCallbacks() {
        this.getParent().removeTimeoutCallbacks();
    }

    protected void sendTimeoutCallbacks() {
        this.getParent().sendTimeoutCallbacks();
    }

    @NonNull
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        return this.getParent().createOrSetConferenceWithParams(conferenceId, conferenceAlias);
    }

    @NonNull
    protected ConferenceInformation getConferenceInformation(@NonNull String conferenceId) {
        return this.getParent().getConferenceInformation(conferenceId);
    }

    protected void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        this.getParent().moveConference(conferenceId, conferenceInformation);
    }

    protected void joinLock() {
        this.getParent().joinLock();
    }

    protected void joinUnlock() {
        this.getParent().joinUnlock();
    }

    @NonNull
    protected Promise<Conference> joinConference(@NonNull ConferenceInformation conference) {
        return this.getParent().joinConferenceInternalPackage(conference);
    }

    protected void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        this.getParent().setCurrentConferenceIfNotInPreviousConference(conference);
    }

    protected boolean is200(@Nullable Response response) {
        return 200 == (Integer)Opt.of((Object)response).then(Response::code).or((Object)0);
    }
}

