package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiRecording;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;

public class StopRecordingPromiseable extends AbstractPromiseable<Boolean, IRestApiRecording> {

    public StopRecordingPromiseable(@NonNull ConferenceService parent,
                                    @NonNull MediaDeviceService mediaDeviceService,
                                    @NonNull IRestApiRecording provider,
                                    @Nullable ConferenceInformation information,
                                    @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            ConferenceInformation information = getInformation();
            if (null == information || null == Opt.of(information.getConference()).then(Conference::getId).orNull()) {
                Promise.reject(new NotInConferenceException());
                return;
            }

            final Call<ResponseBody> call = getApiRestCall().stopRecording(information.getConference().getId());
            HttpHelper.promise(call, ServerErrorOrigin.STOP_RECORDING)
                    .then(answer -> {
                        int code = Opt.of(answer).then(a -> a.response).then(Response::code).or(0);
                        solver.resolve(200 == code);
                    })
                    .error(solver::reject);
        });
    }
}
