package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.sdk.events.error.GetConferenceStatusErrorEvent;
import com.voxeet.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiOutConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Opt;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;

import retrofit2.Call;

public class GetConferenceStatusPromiseable extends AbstractPromiseable<ConferenceStatusResult, IRestApiOutConference> {

    public GetConferenceStatusPromiseable(@NonNull ConferenceService parent,
                                          @NonNull MediaDeviceService mediaDeviceService,
                                          @NonNull IRestApiOutConference provider,
                                          @Nullable ConferenceInformation information,
                                          @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @NonNull
    @Override
    public Promise<ConferenceStatusResult> createPromise() {
        return new Promise<>(solver -> {
            String id = Opt.of(getInformation()).then(ConferenceInformation::getConference).then(Conference::getId).or("");
            final Call<ConferenceStatusResult> user = getApiRestCall().conferenceStatus(id);
            HttpHelper.promise(user, ServerErrorOrigin.CONFERENCE_STATUS)
                    .then(answer -> {
                        ConferenceStatusResult object = Opt.of(answer).then(a -> a.object).orNull();

                        if (null != object) {
                            for (ConferenceUser conferenceUser : Opt.of(object).then(ConferenceStatusResult::getConferenceUsers).or(new ArrayList<>())) {
                                log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                            }
                        }
                        getEventBus().post(object);
                        solver.resolve(object);
                    })
                    .error(error -> {
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(getParent().handleError(error));
                            getEventBus().post(event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, error);
                        } catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject(exception);
                        }
                    });
        });
    }
}
