package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.voxeet.promise.Promise;
import com.voxeet.promise.solve.ThenVoid;
import com.voxeet.sdk.models.v2.ServerErrorOrigin;
import com.voxeet.sdk.network.endpoints.IRestApiConferenceAccess;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;

import org.greenrobot.eventbus.EventBus;

import okhttp3.ResponseBody;
import retrofit2.Call;

public class DeclinePromise extends AbstractPromiseable<Boolean, IRestApiConferenceAccess> {
    private static final String TAG = DeclinePromise.class.getSimpleName();
    private final String conferenceId;

    public DeclinePromise(@NonNull ConferenceService parent,
                          @NonNull MediaDeviceService mediaDeviceService,
                          @NonNull IRestApiConferenceAccess provider,
                          @Nullable ConferenceInformation information,
                          @NonNull EventBus eventBus,
                          @NonNull String conferenceId) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceId = conferenceId;
    }

    @NonNull
    @Override
    public Promise<Boolean> createPromise() {
        return new Promise<>(solver -> {
            final Call<ResponseBody> user = getApiRestCall().decline(conferenceId);

            HttpHelper.promise(user, ServerErrorOrigin.DECLINE)
                    .then((ThenVoid<HttpHelper.HttpAnswer<ResponseBody>>) answer -> solver.resolve(is200(answer.response)))
                    .error(solver::reject);
        });
    }
}
