package com.voxeet.sdk.services.conference.information;

import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.json.ParticipantInfo;
import com.voxeet.sdk.models.Participant;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.media.VideoState;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConferenceInformationHolder {
    private final ConcurrentHashMap<String, ConferenceInformation> mConferenceInformations;

    public ConferenceInformationHolder() {
        mConferenceInformations = new ConcurrentHashMap<>();
    }

    @NonNull
    public ConferenceInformation getInformation(@NonNull String conferenceId) {
        SessionService sessionService = VoxeetSdk.session();
        ConferenceInformation information = null;
        Participant participant = null;

        if (mConferenceInformations.containsKey(conferenceId)) {
            information = mConferenceInformations.get(conferenceId);
        }

        if (null == information) {
            participant = sessionService.getParticipant();
            if (null == participant) participant = new Participant(new ParticipantInfo());
            information = new ConferenceInformation(participant, conferenceId);
            mConferenceInformations.put(conferenceId, information);
        }

        return information;
    }

    public void setVideoState(@NonNull ConferenceInformation conferenceInformation, @NonNull VideoState videoState) {
        conferenceInformation.setVideoState(videoState);
    }

    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        String previousId = conferenceInformation.getConference().getId();
        conferenceInformation.getConference().setConferenceId(conferenceId);
        mConferenceInformations.remove(previousId);
        mConferenceInformations.put(conferenceId, conferenceInformation);
    }

    public void clearConferencesInformation() {
        Log.d("ConferenceService", "clearConferencesInformation: need consensus to what must be done when logging out...");
        synchronized (mConferenceInformations) {
            Set<Map.Entry<String, ConferenceInformation>> entries = mConferenceInformations.entrySet();
            for (Map.Entry<String, ConferenceInformation> entry : entries) {
                entry.getValue().clean();
            }

            mConferenceInformations.clear();
        }
    }
}
