package com.voxeet.sdk.media.audio;

import com.voxeet.sdk.utils.Annotate;

/**
 * The ParticipantPosition model informs about [participant position](/documentation/sdk/reference/android/models/participantposition#participantposition) in the spatial audio environment. It contains information about the [distance](/documentation/sdk/reference/android/models/participantposition#distance) and [angle](/documentation/sdk/reference/android/models/participantposition#angle).
 */
@Annotate
public class ParticipantPosition {

    /**
     * The distance from the current `Participant` (in meters).
     */
    public double distance;

    /**
     * The angle (in radians).
     */
    public double angle;

    private ParticipantPosition() {

    }

    /**
     * Constructs a spatialized representation of the `Participant`.
     *
     * @param distance The distance.
     * @param angle The angle (in radians).
     */
    public ParticipantPosition(double distance, double angle) {
        this();

        this.distance = distance;
        this.angle = angle;
    }
}
