package com.voxeet.sdk.media.audio;

import android.support.annotation.NonNull;

import com.voxeet.audio2.devices.MediaDevice;

public enum AudioRoute {
    ROUTE_HEADSET(false),
    ROUTE_PHONE(true),
    ROUTE_SPEAKER(false),
    ROUTE_BLUETOOTH(false),
    ROUTE_MEDIA(false);

    private boolean mProximitySensor;

    AudioRoute(boolean proximity_sensor) {
        mProximitySensor = proximity_sensor;
    }

    public boolean useProximitySensor() {
        return mProximitySensor;
    }

    public static AudioRoute valueOf(int value) {
        switch (value) {
            case 0:
                return ROUTE_HEADSET;
            case 1:
                return ROUTE_PHONE;
            case 2:
                return ROUTE_SPEAKER;
            case 3:
                return ROUTE_BLUETOOTH;
            case 4:
                return ROUTE_MEDIA;
            default:
                return ROUTE_SPEAKER;
        }
    }

    public static <TYPE> AudioRoute from(@NonNull MediaDevice<TYPE> device) {
        switch (device.deviceType()) {
            case BLUETOOTH:
                return AudioRoute.ROUTE_BLUETOOTH;
            case NORMAL_MEDIA:
                return AudioRoute.ROUTE_MEDIA;
            case WIRED_HEADSET:
                return AudioRoute.ROUTE_HEADSET;
            case EXTERNAL_SPEAKER:
                return AudioRoute.ROUTE_SPEAKER;
            case INTERNAL_SPEAKER:
                return AudioRoute.ROUTE_PHONE;
            case USB:
            default:
                return AudioRoute.ROUTE_MEDIA;
        }
    }

    public boolean isCompatible(@NonNull MediaDevice device) {
        switch (device.deviceType()) {
            case BLUETOOTH:
                return this.equals(AudioRoute.ROUTE_BLUETOOTH);
            case NORMAL_MEDIA:
                return this.equals(AudioRoute.ROUTE_MEDIA);
            case WIRED_HEADSET:
                return this.equals(AudioRoute.ROUTE_HEADSET);
            case EXTERNAL_SPEAKER:
                return this.equals(AudioRoute.ROUTE_SPEAKER);
            case INTERNAL_SPEAKER:
                return this.equals(AudioRoute.ROUTE_PHONE);
            case USB:
            default:
                return this.equals(AudioRoute.ROUTE_MEDIA);
        }
    }
}