package com.voxeet.sdk.json.internal;

import android.support.annotation.NonNull;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.HashMap;

/**
 * The ParamsHolder model [sets video codecs](/documentation/sdk/reference/android/models/paramsholder#setVideoCodec) and [builds the holder](/documentation/sdk/reference/android/models/paramsholder#build) in a native HashMap.
 */
@Annotate
public class ParamsHolder {

    @NonNull
    private HashMap<String, Object> values = new HashMap<>();

    @NoDocumentation
    public ParamsHolder() {

    }

    @NoDocumentation
    public ParamsHolder(@NonNull HashMap<String, Object> values) {
        this.values = values;
    }

    /**
     * Sets video codecs (VP8 or H264) for the current conference.
     *
     * @param videoCodec The video codec.
     * @return the current instance.
     */
    public ParamsHolder setVideoCodec(@NonNull String videoCodec) {
        return putValue("videoCodec", videoCodec);
    }

    public ParamsHolder setSimulcast(boolean state) {
        return putValue("simulcast", state);
    }

    @NoDocumentation
    public ParamsHolder putValue(@NonNull String key, Object value) {
        values.put(key, value);
        return this;
    }
    /**
     * Builds the holder into a native HashMap.
     *
     * @return the created map.
     */
    @NonNull
    public HashMap<String, Object> build() {
        return values;
    }
}
