package com.voxeet.sdk.json;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromWebsocket;
import com.voxeet.sdk.utils.NoDocumentation;

import java.util.List;

//TODO The ConferenceUser in the list should be mapped into something else with only their quality

/**
 * Event fired when the quality of the conference has been updated from server side.
 */
@Annotate
@FromWebsocket
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName(EventNames.QUALITY_UPDATED)
public class QualityUpdated extends Event {

    /**
     * The conference id from which the event has been fired.
     */
    @JsonProperty("conference_id")
    @NonNull
    public String conferenceId;

    /**
     * The list of users corresponding, using the Quality field
     */
    @JsonProperty("quality_indicators")
    @NonNull
    public List<ConferenceUser> participants;

    @NoDocumentation
    public QualityUpdated() {

    }

    @NoDocumentation
    @Override
    public String getType() {
        return EventNames.QUALITY_UPDATED;
    }
}
