package com.voxeet.sdk.json;

import android.support.annotation.NonNull;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.voxeet.sdk.events.sdk.QualityIndicators;
import com.voxeet.sdk.events.success.ConferenceUpdated;
import com.voxeet.sdk.events.websocket.RenegociationEndedEvent;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonSubTypes({
        @JsonSubTypes.Type(name = EventNames.OFFER_CREATED, value = OfferCreated.class),
        @JsonSubTypes.Type(name = EventNames.QUALITY_UPDATED, value = QualityUpdated.class),
        @JsonSubTypes.Type(name = EventNames.QUALITY_INDICATORS, value = QualityIndicators.class),
        @JsonSubTypes.Type(name = EventNames.CONFERENCE_MESSAGE_RECEIVED, value = ConferenceMessageReceived.class),
        @JsonSubTypes.Type(name = EventNames.BROADCAST_EVENT, value = BroadcastEvent.class),
        @JsonSubTypes.Type(name = EventNames.CONFERENCE_DESTROYED, value = ConferenceDestroyedPush.class),
        @JsonSubTypes.Type(name = EventNames.PARTICIPANT_UPDATED, value = ParticipantUpdated.class),
        @JsonSubTypes.Type(name = EventNames.OWN_CONFERENCE_CREATED, value = OwnConferenceCreated.class),
        @JsonSubTypes.Type(name = EventNames.USER_LOG_OUT, value = UserLogoutEvent.class),
        @JsonSubTypes.Type(name = EventNames.OWN_EXTERNAL_INVITATION, value = OwnExternalInvitationSentEvent.class),
        @JsonSubTypes.Type(name = EventNames.CONTACT_PROFILE_UPDATED, value = ProfileUpdatedEvent.class),
        @JsonSubTypes.Type(name = EventNames.OWN_CONTACT_REMOVED, value = OwnContactRemovedEvent.class),
        @JsonSubTypes.Type(name = EventNames.FILE_DELETED, value = FileDeletedEvent.class),
        @JsonSubTypes.Type(name = EventNames.FILE_ADDED, value = FileAddedEvent.class),
        @JsonSubTypes.Type(name = EventNames.INVITATION_RECEIVED, value = InvitationReceivedEvent.class),
        @JsonSubTypes.Type(name = EventNames.TYPING_DETECTION, value = TypingDetection.class),
        @JsonSubTypes.Type(name = EventNames.RECORDING_STATUS_UPDATE, value = RecordingStatusUpdatedEvent.class),
        @JsonSubTypes.Type(name = EventNames.FILE_PRESENTATION_UPDATED, value = FilePresentationUpdated.class),
        @JsonSubTypes.Type(name = EventNames.FILE_PRESENTATION_STARTED, value = FilePresentationStarted.class),
        @JsonSubTypes.Type(name = EventNames.FILE_PRESENTATION_STOPPED, value = FilePresentationStopped.class),
        @JsonSubTypes.Type(name = EventNames.OWN_USER_INVITED, value = OwnUserInvited.class),
        @JsonSubTypes.Type(name = EventNames.USER_INVITED, value = UserInvited.class),
        @JsonSubTypes.Type(name = EventNames.CONFERENCE_ENDED, value = ConferenceEnded.class),
        @JsonSubTypes.Type(name = EventNames.PARTICIPANT_SWITCH, value = ParticipantSwitched.class),
        @JsonSubTypes.Type(name = EventNames.PARTICIPANT_ADDED, value = ParticipantAdded.class),
        @JsonSubTypes.Type(name = EventNames.OWN_USER_SWITCH, value = OwnConferenceParticipantSwitch.class),
        @JsonSubTypes.Type(name = EventNames.FILE_CONVERTED, value = FileConverted.class),
        @JsonSubTypes.Type(name = EventNames.PEER_CONNECTION_UPDATED, value = PeerConnectionStatusUpdated.class),
        @JsonSubTypes.Type(name = EventNames.SDK_CONFERENCE_CREATED, value = SdkConferenceCreated.class),
        @JsonSubTypes.Type(name = EventNames.SDK_CONFERENCE_ENDED, value = SdkConferenceEnded.class),
        @JsonSubTypes.Type(name = EventNames.CONFERENCE_STATS, value = ConferenceStats.class),
        @JsonSubTypes.Type(name = EventNames.CONFERENCE_UPDATED, value = ConferenceUpdated.class),
        @JsonSubTypes.Type(name = EventNames.RENEGOCIATION_ENDED, value = RenegociationEndedEvent.class),
        @JsonSubTypes.Type(name = EventNames.START_SCREENSHARE, value = StartScreenSharingResponse.class),
        @JsonSubTypes.Type(name = EventNames.STOP_SCREENSHARE, value = StopScreenSharingResponse.class),
        @JsonSubTypes.Type(name = EventNames.VIDEO_PRESENTATION_STARTED, value = VideoPresentationStarted.class),
        @JsonSubTypes.Type(name = EventNames.VIDEO_PRESENTATION_STOPPED, value = VideoPresentationStopped.class),
        @JsonSubTypes.Type(name = EventNames.VIDEO_PRESENTATION_PLAY, value = VideoPresentationPlay.class),
        @JsonSubTypes.Type(name = EventNames.VIDEO_PRESENTATION_PAUSED, value = VideoPresentationPaused.class),
        @JsonSubTypes.Type(name = EventNames.VIDEO_PRESENTATION_SEEK, value = VideoPresentationSeek.class)
})
public abstract class Event implements InterfaceEvent {

    @JsonIgnore
    public static final String TAG = Event.class.getSimpleName();

    @JsonIgnore
    @NonNull
    public abstract String getType();
}
