package com.voxeet.sdk.events.sdk;

import com.voxeet.sdk.events.SuccessEvent;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.FromSDK;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Emitted when the message from the specific participant is received at the specific conference.
 */
@FromSDK
@Annotate
public class MessageReceived extends SuccessEvent {

    /**
     * The ID of the sender.
     */
    public String participantId;

    /**
     * The conference ID.
     */
    public String conferenceId;

    /**
     * The corresponding message.
     */
    public String message;

    @NoDocumentation
    public MessageReceived(String participantId, String conferenceId, String message) {
        this.participantId = participantId;
        this.conferenceId = conferenceId;
        this.message = message;
    }

}
