package com.voxeet.sdk.events.promises;

import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * The InConferenceException model is an exception that is sent when the participant that is connected to an existing conference tries to connect a new one. Participants can not enter a new conference before leaving the current call.
 */
@Annotate
public class InConferenceException extends Throwable {

    @NoDocumentation
    public InConferenceException() {
        super("You are in a conference");
    }
}
