/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopVideoAnswerEvent;
import com.voxeet.sdk.events.v2.VideoStateEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.StopVideoResponse;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StopVideoPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StopVideoPromise.class.getSimpleName();
    private final ConferenceInformationHolder conferenceInformationHolder;

    public StopVideoPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull ConferenceInformationHolder conferenceInformationHolder) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.conferenceInformationHolder = conferenceInformationHolder;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    StopVideoPromise.this.log("stoppping video");
                    final ConferenceInformation information = StopVideoPromise.this.getInformation();
                    if (null == information || !StopVideoPromise.this.getParent().isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (StopVideoPromise.this.getMediaService().hasMedia()) {
                            StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    if (!VideoState.STARTED.equals((Object)information.getVideoState())) {
                        StopVideoPromise.this.log("stopping video failed : maybe already in some...");
                        throw new IllegalStateException("can not stop video, pending ?");
                    }
                    StopVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPING);
                    StopVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPING));
                    String conferenceId = information.getConference().getId();
                    if (!StopVideoPromise.this.getMediaService().hasMedia()) {
                        Log.d((String)TAG, (String)"stopVideo: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                    Call<StopVideoResponse> stopVideo = StopVideoPromise.this.getProvider().getStopVideoObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(stopVideo, new HttpHelper.HttpCallback<StopVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StopVideoResponse object, @NonNull Response<StopVideoResponse> response) {
                            if (StopVideoPromise.this.getMediaService().hasMedia()) {
                                StopVideoPromise.this.getMediaService().getMedia().stopVideo();
                            }
                            information.setRequestedOwnVideo(false);
                            StopVideoAnswerEvent event = new StopVideoAnswerEvent(true);
                            StopVideoPromise.this.getEventBus().post((Object)event);
                            StopVideoPromise.this.createVideoAnswer(object.userId, object.description, object.candidates).then(new PromiseExec<Boolean, Object>(){

                                @Override
                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    StopVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                                    StopVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                                    solver.resolve(true);
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(Throwable error) {
                                    ExceptionManager.sendException(error);
                                    error.printStackTrace();
                                    StopVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                                    StopVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                                    solver.resolve(true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable t, @Nullable Response<StopVideoResponse> response) {
                            solver.reject(t);
                            StopVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                            StopVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject(exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject(exception);
                }
                catch (Exception exception) {
                    solver.reject(exception);
                }
            }
        });
    }
}

