/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.sdk.StopScreenShareAnswerEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.StopScreenSharingResponse;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StopScreenSharePromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StopScreenSharePromise.class.getSimpleName();

    public StopScreenSharePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                try {
                    final ConferenceInformation information = StopScreenSharePromise.this.getInformation();
                    if (null == information || !StopScreenSharePromise.this.getParent().isInConference()) {
                        Log.d((String)TAG, (String)"stopVideo: not in conf");
                        if (StopScreenSharePromise.this.getMediaService().hasMedia()) {
                            StopScreenSharePromise.this.getMediaService().getMedia().stopVideo();
                        }
                        throw new NotInConferenceException();
                    }
                    String conferenceId = information.getConference().getId();
                    if (!StopScreenSharePromise.this.isInConference()) {
                        Log.d((String)TAG, (String)"stopScreenShare: not in conf");
                        if (StopScreenSharePromise.this.hasMedia()) {
                            StopScreenSharePromise.this.getMedia().stopScreenCapturer();
                        }
                        throw new NotInConferenceException();
                    }
                    if (!StopScreenSharePromise.this.hasMedia()) {
                        Log.d((String)TAG, (String)"stopScreenShare: media is null");
                        throw new MediaEngineException("media is null");
                    }
                    StopScreenSharePromise.this.getMedia().stopScreenCapturer();
                    Call<StopScreenSharingResponse> stopVideo = StopScreenSharePromise.this.getProvider().getStopScreenShareObservable(conferenceId, VoxeetPreferences.id());
                    HttpHelper.enqueue(stopVideo, new HttpHelper.HttpCallback<StopScreenSharingResponse>(){

                        @Override
                        public void onSuccess(@NonNull StopScreenSharingResponse object, @NonNull Response<StopScreenSharingResponse> response) {
                            StopScreenSharePromise.this.getMedia().stopScreenCapturer();
                            information.setScreenShareOn(false);
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(true);
                            StopScreenSharePromise.this.getEventBus().post((Object)event);
                            StopScreenSharePromise.this.createVideoAnswer(object.userId, object.description, object.candidates).then(new PromiseExec<Boolean, Object>(){

                                @Override
                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    solver.resolve(true);
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(Throwable error) {
                                    ExceptionManager.sendException(error);
                                    error.printStackTrace();
                                    solver.resolve(true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StopScreenSharingResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            information.setScreenShareOn(false);
                            StopScreenShareAnswerEvent event = new StopScreenShareAnswerEvent(false);
                            StopScreenSharePromise.this.getEventBus().post((Object)event);
                            solver.reject(e);
                        }
                    });
                }
                catch (MediaEngineException exception) {
                    solver.reject(exception);
                }
                catch (NotInConferenceException exception) {
                    solver.reject(exception);
                }
                catch (Exception exception) {
                    solver.reject(exception);
                }
            }
        });
    }
}

