/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.PromisePermissionRefusedEventException;
import com.voxeet.sdk.events.v2.VideoStateEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.StartVideoResponse;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.services.media.VideoState;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class StartVideoPromise
extends AbstractPromiseable<Boolean> {
    private static final String TAG = StartVideoPromise.class.getSimpleName();
    private final boolean isDefaultFrontFacing;
    private final ConferenceInformationHolder conferenceInformationHolder;

    public StartVideoPromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, boolean isDefaultFrontFacing, ConferenceInformationHolder conferenceInformationHolder) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.isDefaultFrontFacing = isDefaultFrontFacing;
        this.conferenceInformationHolder = conferenceInformationHolder;
    }

    @Override
    @NonNull
    public Promise<Boolean> createPromise() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                final ConferenceInformation information = StartVideoPromise.this.getInformation();
                try {
                    String defaultCameraName;
                    CameraContext provider = StartVideoPromise.this.getMediaService().getCameraContext();
                    provider.setDefaultCameraFront(StartVideoPromise.this.isDefaultFrontFacing);
                    StartVideoPromise.this.log("starting video");
                    if (!Validate.hasCameraPermissions(StartVideoPromise.this.getParent().getContext())) {
                        PermissionRefusedEvent event = new PermissionRefusedEvent(PermissionRefusedEvent.Permission.CAMERA);
                        StartVideoPromise.this.getEventBus().post((Object)event);
                        throw new PromisePermissionRefusedEventException(event);
                    }
                    if (!StartVideoPromise.this.getMediaService().hasMedia()) {
                        Log.d((String)TAG, (String)"startVideo: media is null");
                        throw new MediaEngineException("Media is null, invalid state");
                    }
                    if (null == information) {
                        Log.d((String)TAG, (String)"startVideo: information is null");
                        throw new MediaEngineException("ConferenceInformation is null, invalid state");
                    }
                    if (!VideoState.STOPPED.equals((Object)information.getVideoState())) {
                        StartVideoPromise.this.log("starting video failed : maybe already in some...");
                        throw new IllegalStateException("can not start video, pending ?");
                    }
                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STARTING);
                    StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STARTING));
                    if (ConferenceUserType.LISTENER.equals((Object)information.getConferenceUserType())) {
                        Log.d((String)TAG, (String)"startVideo: you are a listener, you can't start the video");
                        solver.resolve(false);
                        return;
                    }
                    String string2 = defaultCameraName = StartVideoPromise.this.isDefaultFrontFacing ? provider.getFrontCameraName() : provider.getBackCameraName();
                    if (null == defaultCameraName) {
                        throw new MediaEngineException("DefaultCamera is null, invalid state");
                    }
                    information.setRequestedOwnVideo(true);
                    StartVideoPromise.this.getMediaService().getMedia().startVideo(defaultCameraName);
                    Call<StartVideoResponse> startVideo = StartVideoPromise.this.getProvider().getStartVideoObservable(StartVideoPromise.this.getInformation().getConference().getId(), VoxeetPreferences.id());
                    HttpHelper.enqueue(startVideo, new HttpHelper.HttpCallback<StartVideoResponse>(){

                        @Override
                        public void onSuccess(@NonNull StartVideoResponse object, @NonNull Response<StartVideoResponse> response) {
                            StartVideoPromise.this.getInformation().setRequestedOwnVideo(true);
                            StartVideoPromise.this.createVideoAnswer(object.userId, object.description, object.candidates).then(new PromiseExec<Boolean, Object>(){

                                @Override
                                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> internal_solver) {
                                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STARTED);
                                    StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STARTED));
                                    solver.resolve(true);
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(Throwable error) {
                                    StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                                    StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                                    StartVideoPromise.this.getMediaService().getMedia().stopVideo();
                                    ExceptionManager.sendException(error);
                                    error.printStackTrace();
                                    solver.resolve(true);
                                }
                            });
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<StartVideoResponse> response) {
                            HttpException.dumpErrorResponse(response);
                            e.printStackTrace();
                            StartVideoPromise.this.conferenceInformationHolder.setVideoState(information, VideoState.STOPPED);
                            StartVideoPromise.this.getEventBus().post((Object)new VideoStateEvent(information.getConference(), VideoState.STOPPED));
                            StartVideoPromise.this.getMediaService().getMedia().stopVideo();
                            information.setRequestedOwnVideo(false);
                            solver.reject(e);
                        }
                    });
                }
                catch (PromisePermissionRefusedEventException exception) {
                    solver.reject(exception);
                }
                catch (MediaEngineException exception) {
                    solver.reject(exception);
                }
                catch (Exception exception) {
                    solver.reject(exception);
                }
            }
        });
    }
}

