/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.json.SdkConferenceInvitation;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class InvitePromise
extends AbstractPromiseable<List<User>> {
    private final String TAG = InvitePromise.class.getSimpleName();
    private final List<String> ids;
    private final String conferenceId;

    public InvitePromise(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus, @NonNull String conferenceId, @NonNull List<String> ids) {
        super(parent, mediaDeviceService, provider, information, eventBus);
        this.ids = ids;
        this.conferenceId = conferenceId;
    }

    @Override
    @NonNull
    public Promise<List<User>> createPromise() {
        return new Promise<List<User>>(new PromiseSolver<List<User>>(){

            @Override
            public void onCall(final @NonNull Solver<List<User>> solver) {
                InvitePromise.this.removeTimeoutCallbacks();
                InvitePromise.this.sendTimeoutCallbacks();
                boolean sdk = InvitePromise.this.isSDK();
                ArrayList<String> voxeetIds = sdk ? null : new ArrayList<String>();
                final ArrayList<String> externalIds = new ArrayList<String>();
                externalIds.addAll(InvitePromise.this.ids);
                if (!sdk) {
                    voxeetIds.addAll(InvitePromise.this.ids);
                }
                if (null == InvitePromise.this.conferenceId) {
                    try {
                        throw new IllegalStateException("You're not in a conference");
                    }
                    catch (Exception e) {
                        solver.reject(e);
                        return;
                    }
                }
                Call<ResponseBody> user = InvitePromise.this.getProvider().getInviteObservable(InvitePromise.this.conferenceId, new SdkConferenceInvitation(voxeetIds, externalIds));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        ArrayList<User> list = new ArrayList<User>();
                        try {
                            String body = ((ResponseBody)response.body()).string();
                            Log.d((String)InvitePromise.this.TAG, (String)("onNext: " + body));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (response.code() == 200) {
                            for (String userId : externalIds) {
                                if (userId.equals(VoxeetPreferences.id())) continue;
                                Log.d((String)InvitePromise.this.TAG, (String)("Conference participant with id: " + userId + " invited"));
                                list.add(InvitePromise.this.updateConferenceParticipants(userId, ConferenceUserStatus.IN_PROGRESS));
                            }
                        }
                        solver.resolve(list);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        e.printStackTrace();
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

