/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.events.error.GetConferenceStatusErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.promises.PromiseGetConferenceStatusErrorEventException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatusPromiseable
extends AbstractPromiseable<ConferenceStatusResult> {
    public GetConferenceStatusPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceStatusResult> createPromise() {
        return new Promise<ConferenceStatusResult>(new PromiseSolver<ConferenceStatusResult>(){

            @Override
            public void onCall(final @NonNull Solver<ConferenceStatusResult> solver) {
                Call<ConferenceStatusResult> user = GetConferenceStatusPromiseable.this.getProvider().getConferenceStatusObservable(GetConferenceStatusPromiseable.this.getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ConferenceStatusResult>(){

                    @Override
                    public void onSuccess(@NonNull ConferenceStatusResult object, @NonNull Response<ConferenceStatusResult> response) {
                        try {
                            if (null != response && null != object.getConferenceUsers()) {
                                for (ConferenceUser conferenceUser : object.getConferenceUsers()) {
                                    GetConferenceStatusPromiseable.this.log(conferenceUser.getUserId() + " / " + conferenceUser.getStatus());
                                }
                                GetConferenceStatusPromiseable.this.log("Dispatching mConference status result");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        GetConferenceStatusPromiseable.this.getEventBus().post((Object)object);
                        solver.resolve(object);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceStatusResult> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatusPromiseable.this.log("Error while getting mConference history");
                        e.printStackTrace();
                        try {
                            GetConferenceStatusErrorEvent event = new GetConferenceStatusErrorEvent(GetConferenceStatusPromiseable.this.getParent().handleError(e));
                            GetConferenceStatusPromiseable.this.getEventBus().post((Object)event);
                            throw new PromiseGetConferenceStatusErrorEventException(event, e);
                        }
                        catch (PromiseGetConferenceStatusErrorEventException exception) {
                            solver.reject(exception);
                            return;
                        }
                    }
                });
            }
        });
    }
}

