/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.sdk.ConferenceUsersInvitedResult;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceStatus
extends AbstractPromiseable<ConferenceUsersInvitedResult> {
    public GetConferenceStatus(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceUsersInvitedResult> createPromise() {
        return new Promise<ConferenceUsersInvitedResult>(new PromiseSolver<ConferenceUsersInvitedResult>(){

            @Override
            public void onCall(final @NonNull Solver<ConferenceUsersInvitedResult> solver) {
                Call<ConferenceStatusResult> user = GetConferenceStatus.this.getProvider().getConferenceStatusObservable(GetConferenceStatus.this.getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ConferenceStatusResult>(){

                    @Override
                    public void onSuccess(@NonNull ConferenceStatusResult object, @NonNull Response<ConferenceStatusResult> response) {
                        List<ConferenceUser> users = ConferenceUtils.getConferenceUserInState(object.getConferenceUsers(), ConferenceUserStatus.CONNECTING);
                        GetConferenceStatus.this.log("Successfully retrieved connecting users");
                        ConferenceUsersInvitedResult event = new ConferenceUsersInvitedResult(users);
                        solver.resolve(event);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ConferenceStatusResult> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceStatus.this.log("Error while retrieving connecting users");
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

