/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services.conference.promises;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.events.error.GetConferenceHistoryErrorEvent;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.sdk.ConferenceHistoryResult;
import com.voxeet.sdk.models.v1.HistoryConference;
import com.voxeet.sdk.services.AbstractPromiseable;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.utils.HttpHelper;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import retrofit2.Call;
import retrofit2.Response;

public class GetConferenceHistoryPromiseable
extends AbstractPromiseable<ConferenceHistoryResult> {
    public GetConferenceHistoryPromiseable(@NonNull ConferenceService parent, @NonNull MediaDeviceService mediaDeviceService, @NonNull ConferenceSdkObservableProvider provider, @Nullable ConferenceInformation information, @NonNull EventBus eventBus) {
        super(parent, mediaDeviceService, provider, information, eventBus);
    }

    @Override
    @NonNull
    public Promise<ConferenceHistoryResult> createPromise() {
        return new Promise<ConferenceHistoryResult>(new PromiseSolver<ConferenceHistoryResult>(){

            @Override
            public void onCall(final @NonNull Solver<ConferenceHistoryResult> solver) {
                Call<List<HistoryConference>> user = GetConferenceHistoryPromiseable.this.getProvider().getConferenceHistoryObservable(GetConferenceHistoryPromiseable.this.getInformation().getConference().getId());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<List<HistoryConference>>(){

                    @Override
                    public void onSuccess(@NonNull List<HistoryConference> object, @NonNull Response<List<HistoryConference>> response) {
                        GetConferenceHistoryPromiseable.this.log("Dispatching mConference history response");
                        solver.resolve(new ConferenceHistoryResult(object));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<List<HistoryConference>> response) {
                        HttpException.dumpErrorResponse(response);
                        GetConferenceHistoryPromiseable.this.log("Error while retrieving mConference history");
                        GetConferenceHistoryPromiseable.this.getEventBus().post((Object)new GetConferenceHistoryErrorEvent(GetConferenceHistoryPromiseable.this.getParent().handleError(e)));
                        solver.reject(e);
                    }
                });
            }
        });
    }
}

