/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.sdk.events.sdk.ConferenceTimeoutUserJoinedEvent;
import com.voxeet.sdk.services.ConferenceService;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;

class TimeoutRunnable
implements Runnable {
    @NonNull
    private EventBus mEventBus;
    @NonNull
    ConferenceService mService;
    private long mTimeout;
    private boolean mCanceled;
    private boolean mTriggered;

    private TimeoutRunnable() {
        this.setCanceled(false);
        this.mTriggered = false;
    }

    TimeoutRunnable(@NonNull ConferenceService service, @NonNull EventBus event_bus, long timeout) {
        this();
        this.mService = service;
        this.mEventBus = event_bus;
        this.mTimeout = timeout;
    }

    void setCanceled(boolean canceled) {
        this.mCanceled = canceled;
    }

    private boolean isCanceled() {
        return this.mCanceled;
    }

    @Override
    public void run() {
        if (!this.isCanceled()) {
            this.mService.leave().then(new PromiseExec(){

                public void onCall(@Nullable Object o, @NonNull Solver solver) {
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(Throwable error) {
                    error.printStackTrace();
                }
            });
            this.mEventBus.post((Object)new ConferenceTimeoutUserJoinedEvent(this.mTimeout));
            this.mTriggered = true;
        }
    }

    boolean isTriggered() {
        return this.mTriggered;
    }
}

