/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import com.voxeet.sdk.AbstractVoxeetService;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.json.RecordingStatusUpdatedEvent;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.RecordingStatus;
import com.voxeet.sdk.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.promises.StartRecordingPromiseable;
import com.voxeet.sdk.services.conference.promises.StopRecordingPromiseable;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import java.util.Date;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Annotate
public class RecordingService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private static final String TAG = RecordingService.class.getSimpleName();
    private ConferenceSdkObservableProvider mConferenceObservableProvider = new ConferenceSdkObservableProvider();
    private boolean isRecording = false;
    private Context mContext;
    private boolean isICERestartEnabled = false;

    @NoDocumentation
    public RecordingService(VoxeetSdk instance) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
        this.mContext = instance.getApplicationContext();
        this.registerEventBus();
    }

    public Promise<Boolean> start() {
        ConferenceService service = VoxeetSdk.conference();
        return new StartRecordingPromiseable(service, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, service.getCurrentConference(), this.getEventBus()).createPromise();
    }

    public Promise<Boolean> stop() {
        ConferenceService service = VoxeetSdk.conference();
        return new StopRecordingPromiseable(service, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, service.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(RecordingStatusUpdatedEvent recordingStatusUpdateEvent) {
        ConferenceService service = VoxeetSdk.conference();
        if (null == service) {
            return;
        }
        String conferenceId = recordingStatusUpdateEvent.conferenceId;
        ConferenceInformation information = service.getConferenceInformation(conferenceId);
        if (null == information) {
            return;
        }
        Conference conference = information.getConference();
        User user = service.findUserById(recordingStatusUpdateEvent.userId);
        if (user != null) {
            Conference.RecordingInformation recording = new Conference.RecordingInformation();
            RecordingStatus status = RecordingStatus.valueOf(recordingStatusUpdateEvent.recordingStatus);
            if (status == RecordingStatus.RECORDING) {
                this.isRecording = true;
                recording.setStartRecordTimestamp(new Date(recordingStatusUpdateEvent.timeStamp));
                recording.setRecordingStatus(RecordingStatus.RECORDING);
                recording.setRecordingUser(recordingStatusUpdateEvent.userId);
            } else {
                this.isRecording = false;
                recording.setStartRecordTimestamp(null);
                recording.setRecordingStatus(RecordingStatus.NOT_RECORDING);
                recording.setRecordingUser(null);
            }
            conference.setRecordingInformation(recording);
        }
    }
}

