/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.push.center.NotificationCenterFactory;
import com.voxeet.push.center.invitation.IIncomingInvitationListener;
import com.voxeet.push.center.invitation.InvitationBundle;
import com.voxeet.push.center.management.EnforcedNotificationMode;
import com.voxeet.push.center.management.NotificationMode;
import com.voxeet.push.center.management.VersionFilter;
import com.voxeet.push.utils.Annotate;
import com.voxeet.sdk.AbstractVoxeetService;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.services.notification.INotificationTokenProvider;
import com.voxeet.sdk.services.notification.NotificationTokenHolderFactory;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import java.util.List;

@Annotate
public class NotificationService
extends AbstractVoxeetService {
    @NoDocumentation
    public NotificationService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Nullable
    public INotificationTokenProvider getNotificationTokenProvider() {
        return NotificationTokenHolderFactory.provider;
    }

    @NonNull
    public NotificationService setNotificationTokenProvider(@Nullable INotificationTokenProvider provider) {
        NotificationTokenHolderFactory.provider = provider;
        return this;
    }

    @NonNull
    public NotificationService setEnforcedNotificationMode(@NonNull EnforcedNotificationMode enforcedNotificationMode) {
        NotificationCenterFactory.instance.setEnforcedNotificationMode(enforcedNotificationMode);
        return this;
    }

    @NonNull
    public NotificationService register(@NonNull NotificationMode notificationMode, @Nullable IIncomingInvitationListener invitationProvider) {
        NotificationCenterFactory.instance.register(notificationMode, invitationProvider);
        return this;
    }

    @NonNull
    public NotificationService register(@NonNull NotificationMode notificationMode, @NonNull VersionFilter filter) {
        NotificationCenterFactory.instance.register(notificationMode, filter);
        return this;
    }

    public void onInvitationReceived(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        NotificationCenterFactory.instance.onInvitationReceived(context, invitationBundle.asMap(), Build.MANUFACTURER, Build.VERSION.SDK_INT);
    }

    @NonNull
    public String onInvitationCanceledReceived(@NonNull Context context, @NonNull InvitationBundle invitationBundle) {
        return NotificationCenterFactory.instance.onInvitationCanceledReceived(context, invitationBundle.asMap(), Build.MANUFACTURER, Build.VERSION.SDK_INT);
    }

    @NonNull
    public Promise<List<User>> invite(String conferenceId, List<UserInfo> userInfos) {
        return VoxeetSdk.conference().invite(conferenceId, userInfos);
    }
}

