/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.os.Build;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.crypto.AbstractNativeMediaCryptoCallback;
import com.voxeet.sdk.AbstractVoxeetService;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.error.CameraSwitchErrorEvent;
import com.voxeet.sdk.events.sdk.CameraSwitchSuccessEvent;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.media.camera.CameraEnumeratorLollipopWrapper;
import com.voxeet.sdk.media.camera.CameraEnumeratorPreLollipopWrapper;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.services.media.VideoSinkHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.concurrent.CopyOnWriteArrayList;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBaseMethods;
import org.webrtc.VideoSink;

@Annotate
public class MediaDeviceService
extends AbstractVoxeetService {
    private CameraContext enumerator;
    private AbstractNativeMediaCryptoCallback mediaCryptoCallback;
    private MediaSDK media;
    private boolean isAudio3DEnabled;
    private CopyOnWriteArrayList<VideoSinkHolder> videoSinkHolders = new CopyOnWriteArrayList();

    @NoDocumentation
    public MediaDeviceService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
        this.enumerator = Build.VERSION.SDK_INT >= 21 ? new CameraEnumeratorLollipopWrapper(instance.getApplicationContext()) : new CameraEnumeratorPreLollipopWrapper(instance.getApplicationContext());
        this.enumerator.setDefaultCameraFront(true);
        this.isAudio3DEnabled = false;
    }

    @NoDocumentation
    public boolean hasMedia() {
        return null != this.media;
    }

    @NoDocumentation
    @Nullable
    public MediaSDK getMedia() {
        return this.media;
    }

    @Nullable
    public EglBaseMethods.Context getEglContext() {
        if (null != this.media) {
            return this.media.getEglBase().getEglBaseContext();
        }
        return null;
    }

    public void setCryptoCallback(@Nullable AbstractNativeMediaCryptoCallback callback) {
        this.mediaCryptoCallback = callback;
    }

    @MainThread
    public boolean attachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        MediaSDK media = this.media;
        if (null == media) {
            return false;
        }
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (null == holder) {
            return false;
        }
        if (!holder.isAttachedTo(stream)) {
            MediaStream previous = holder.getMediaStream();
            if (null != previous) {
                holder.unattach();
            }
            holder.attach(stream);
        }
        return true;
    }

    @MainThread
    public boolean unAttachMediaStream(@NonNull VideoSink videoSink) {
        VideoSinkHolder holder = this.getOrCreate(videoSink);
        if (null == holder) {
            return false;
        }
        holder.unattach();
        return true;
    }

    @Deprecated
    @NoDocumentation
    @MainThread
    public boolean unAttachMediaStream(@NonNull MediaStream stream, @NonNull VideoSink videoSink) {
        Log.d((String)"MediaDeviceService", (String)"unAttachMediaStream: calling deprecated unattach method");
        return this.unAttachMediaStream(videoSink);
    }

    public boolean isAudio3DEnabled() {
        return this.isAudio3DEnabled;
    }

    public boolean setAudio3DEnabled(boolean enable) {
        this.isAudio3DEnabled = enable;
        if (null != this.media) {
            return this.media.setAudio3D(enable);
        }
        return false;
    }

    @NonNull
    public Promise<Boolean> switchCamera() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                Validate.notNull((Object)MediaDeviceService.this.getMedia(), "media");
                MediaDeviceService.this.getMedia().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        MediaDeviceService.this.getCameraContext().setDefaultCameraFront(isFrontCamera);
                        MediaDeviceService.this.getEventBus().post((Object)new CameraSwitchSuccessEvent(isFrontCamera));
                        solver.resolve(true);
                    }

                    public void onCameraSwitchError(String errorDescription) {
                        MediaDeviceService.this.getEventBus().post((Object)new CameraSwitchErrorEvent(errorDescription));
                        solver.resolve(false);
                    }
                });
            }
        });
    }

    @NonNull
    public CameraContext getCameraContext() {
        return this.enumerator;
    }

    @MainThread
    @Nullable
    private VideoSinkHolder getOrCreate(@Nullable VideoSink videoSink) {
        if (null == videoSink) {
            return null;
        }
        for (VideoSinkHolder holder : this.videoSinkHolders) {
            if (!holder.equals(videoSink)) continue;
            return holder;
        }
        VideoSinkHolder holder = new VideoSinkHolder(this.media, videoSink);
        this.videoSinkHolders.add(holder);
        return holder;
    }

    @NoDocumentation
    void releaseMedia() {
        for (VideoSinkHolder holder : this.videoSinkHolders) {
            if (!holder.hasVideoSink()) continue;
            holder.clear();
        }
        this.videoSinkHolders.clear();
        if (null != this.media) {
            this.media.stop();
        }
        this.media = null;
    }

    @NoDocumentation
    void createMedia(Context context, String userId, MediaEngine.StreamListener mediaStreamListener, CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, boolean videoOn, boolean useMic) throws MediaEngineException {
        this.media = new MediaSDK(context, userId, mediaStreamListener, cameraEventsHandler, videoOn, useMic, this.mediaCryptoCallback);
        this.media.setAudio3D(this.isAudio3DEnabled);
    }
}

