/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.android.media.MediaEngine;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.MediaStreamType;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.audio.AudioRoute;
import com.voxeet.authent.models.DeviceType;
import com.voxeet.push.center.invitation.InvitationBundle;
import com.voxeet.push.center.management.PushConferenceDestroyed;
import com.voxeet.sdk.AbstractVoxeetService;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.events.error.ParticipantAddedErrorEvent;
import com.voxeet.sdk.events.error.PermissionRefusedEvent;
import com.voxeet.sdk.events.promises.InConferenceException;
import com.voxeet.sdk.events.promises.NotInConferenceException;
import com.voxeet.sdk.events.promises.PromiseConferenceJoinedErrorException;
import com.voxeet.sdk.events.promises.PromiseParticipantAddedErrorEventException;
import com.voxeet.sdk.events.restapi.ConferenceStatusResult;
import com.voxeet.sdk.events.restapi.ResumeConference;
import com.voxeet.sdk.events.sdk.ConferenceHistoryResult;
import com.voxeet.sdk.events.sdk.ConferenceStateEvent;
import com.voxeet.sdk.events.sdk.ConferenceUserQualityUpdatedEvent;
import com.voxeet.sdk.events.sdk.ConferenceUsersInvitedResult;
import com.voxeet.sdk.events.sdk.IncomingCallEvent;
import com.voxeet.sdk.events.sdk.SocketStateChangeEvent;
import com.voxeet.sdk.events.v2.StreamAddedEvent;
import com.voxeet.sdk.events.v2.StreamRemovedEvent;
import com.voxeet.sdk.events.v2.StreamUpdatedEvent;
import com.voxeet.sdk.events.v2.UserAddedEvent;
import com.voxeet.sdk.events.v2.UserUpdatedEvent;
import com.voxeet.sdk.events.websocket.RenegociationEndedEvent;
import com.voxeet.sdk.exceptions.ExceptionManager;
import com.voxeet.sdk.json.ConferenceDestroyedPush;
import com.voxeet.sdk.json.ConferenceEnded;
import com.voxeet.sdk.json.InvitationReceivedEvent;
import com.voxeet.sdk.json.JoinParameters;
import com.voxeet.sdk.json.OfferCreated;
import com.voxeet.sdk.json.OwnConferenceCreated;
import com.voxeet.sdk.json.OwnConferenceUserSwitch;
import com.voxeet.sdk.json.ParticipantAdded;
import com.voxeet.sdk.json.ParticipantUpdated;
import com.voxeet.sdk.json.QualityUpdated;
import com.voxeet.sdk.json.UserInfo;
import com.voxeet.sdk.json.internal.MetadataHolder;
import com.voxeet.sdk.json.internal.ParamsHolder;
import com.voxeet.sdk.media.MediaSDK;
import com.voxeet.sdk.media.audio.UserPosition;
import com.voxeet.sdk.media.camera.CameraContext;
import com.voxeet.sdk.media.peer.PendingPeerCallback;
import com.voxeet.sdk.media.peer.SdpDescription;
import com.voxeet.sdk.media.peer.SdpMessage;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v1.CandidatesPush;
import com.voxeet.sdk.models.v1.ConferenceType;
import com.voxeet.sdk.models.v1.ConferenceUser;
import com.voxeet.sdk.models.v1.ConferenceUserStatus;
import com.voxeet.sdk.models.v1.CreateConferenceResult;
import com.voxeet.sdk.models.v1.Invitation;
import com.voxeet.sdk.models.v1.OfferCandidate;
import com.voxeet.sdk.models.v1.OfferDescription;
import com.voxeet.sdk.models.v1.Participant;
import com.voxeet.sdk.models.v1.SdkParticipant;
import com.voxeet.sdk.network.endpoints.ISdkConferenceRService;
import com.voxeet.sdk.preferences.VoxeetPreferences;
import com.voxeet.sdk.services.AudioService;
import com.voxeet.sdk.services.ConferenceSdkObservableProvider;
import com.voxeet.sdk.services.MediaDeviceService;
import com.voxeet.sdk.services.NotificationService;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.TimeoutRunnable;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import com.voxeet.sdk.services.builders.ConferenceCreateInformation;
import com.voxeet.sdk.services.builders.ConferenceJoinInformation;
import com.voxeet.sdk.services.conference.ConferenceConfigurations;
import com.voxeet.sdk.services.conference.information.ConferenceInformation;
import com.voxeet.sdk.services.conference.information.ConferenceInformationHolder;
import com.voxeet.sdk.services.conference.information.ConferenceState;
import com.voxeet.sdk.services.conference.information.ConferenceUserType;
import com.voxeet.sdk.services.conference.information.LocalConferenceType;
import com.voxeet.sdk.services.conference.promises.CreateConferencePromiseable;
import com.voxeet.sdk.services.conference.promises.DeclinePromise;
import com.voxeet.sdk.services.conference.promises.GetConferenceHistoryPromiseable;
import com.voxeet.sdk.services.conference.promises.GetConferenceStatus;
import com.voxeet.sdk.services.conference.promises.GetConferenceStatusPromiseable;
import com.voxeet.sdk.services.conference.promises.InvitePromise;
import com.voxeet.sdk.services.conference.promises.JoinPromise;
import com.voxeet.sdk.services.conference.promises.LeavePromise;
import com.voxeet.sdk.services.conference.promises.ReplayPromise;
import com.voxeet.sdk.services.conference.promises.StartScreensharePromise;
import com.voxeet.sdk.services.conference.promises.StartVideoPromise;
import com.voxeet.sdk.services.conference.promises.StopScreenSharePromise;
import com.voxeet.sdk.services.conference.promises.StopVideoPromise;
import com.voxeet.sdk.services.conference.promises.SubscribeConferenceEventPromiseable;
import com.voxeet.sdk.services.conference.promises.SubscribeForCallStartPromiseable;
import com.voxeet.sdk.services.conference.promises.UnsubscribeConferenceEventPromiseable;
import com.voxeet.sdk.services.conference.promises.UnsubscribeForCallStartPromiseable;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.AndroidManifest;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.ConferenceUtils;
import com.voxeet.sdk.utils.HttpHelper;
import com.voxeet.sdk.utils.NoDocumentation;
import com.voxeet.sdk.utils.PeerInformation;
import com.voxeet.sdk.utils.Validate;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.ErrorPromise;
import eu.codlab.simplepromise.solve.PromiseExec;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.ResponseBody;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.webrtc.CameraVideoCapturer;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Annotate
public class ConferenceService
extends AbstractVoxeetService<ISdkConferenceRService> {
    private static final String TAG = ConferenceService.class.getSimpleName();
    private final VoxeetSdk mInstance;
    private VoxeetSdk mSDK;
    private ConferenceSdkObservableProvider mConferenceObservableProvider;
    private EventBus mEventBus;
    private boolean mInConference = false;
    private ReentrantLock joinLock = new ReentrantLock();
    private String mConferenceId = null;
    private ConferenceInformationHolder mConferenceInformationHolder = new ConferenceInformationHolder();
    public final ConferenceConfigurations ConferenceConfigurations = new ConferenceConfigurations();
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Context mContext;
    @Nullable
    private TimeoutRunnable timeoutRunnable = null;
    private MediaEngine.StreamListener mediaStreamListener = new MediaEngine.StreamListener(){

        public void onStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamAddedFromInformation(peerInformation, stream);
        }

        public void onStreamUpdated(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamUpdatedFromInformation(peerInformation, stream);
        }

        public void onStreamRemoved(@NonNull String peer) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.Camera);
            this.onStreamRemovedFromInformation(peerInformation);
        }

        public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.ScreenShare);
            this.onStreamAddedFromInformation(peerInformation, stream);
        }

        public void onScreenStreamRemoved(@NonNull String peer) {
            PeerInformation peerInformation = new PeerInformation(peer, MediaStreamType.ScreenShare);
            this.onStreamRemovedFromInformation(peerInformation);
        }

        private void onStreamAddedFromInformation(@NonNull PeerInformation peerInformation, final @NonNull MediaStream stream) {
            final String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)("onStreamAdded: stream for peer " + peer + " " + stream.getType()));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConference();
                    User user = ConferenceService.this.findUserById(peer);
                    Log.d((String)"DUMP_INFORMATION", (String)("New stream for user " + peer + " user := " + user));
                    if (null != conferenceInformation && null == user) {
                        Log.d((String)TAG, (String)("run: WARNING obtained stream for user which did not existed " + peer));
                        user = new User(peer, null);
                        conferenceInformation.getConference().updateUser(user);
                    }
                    if (user != null) {
                        if (!peer.equalsIgnoreCase(VoxeetSdk.session().getUserId()) && ConferenceService.this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout != -1L) {
                            ConferenceService.this.removeTimeoutCallbacks();
                        }
                        user.streamsHandler().insertOrUpdate(stream);
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new StreamAddedEvent(conferenceInformation.getConference(), user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream added");
                    }
                }
            });
        }

        private void onStreamUpdatedFromInformation(@NonNull PeerInformation peerInformation, final @NonNull MediaStream stream) {
            final String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)("onStreamUpdated: screen for peer " + peer));
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceInformation conferenceInformation = ConferenceService.this.getCurrentConference();
                    User user = ConferenceService.this.findUserById(peer);
                    if (null != conferenceInformation && null == user) {
                        Log.d((String)"DUMP_INFORMATION", (String)("run: WARNING obtained stream for user which did not existed " + peer));
                        user = new User(peer, null);
                        conferenceInformation.getConference().updateUser(user);
                    }
                    Log.d((String)TAG, (String)("Updated stream for user " + user));
                    if (user != null) {
                        user.streamsHandler().insertOrUpdate(stream);
                        ConferenceService.this.updateConferenceFromUsers();
                        ConferenceService.this.mEventBus.post((Object)new StreamUpdatedEvent(conferenceInformation.getConference(), user, stream));
                    } else {
                        Log.d((String)TAG, (String)"run: unknown user in stream updated");
                    }
                }
            });
        }

        public void onStreamRemovedFromInformation(final @NonNull PeerInformation peerInformation) {
            final String peer = peerInformation.peerId;
            Log.d((String)"DUMP_INFORMATION", (String)"onStreamRemoved: OnStreamRemoved");
            ConferenceService.this.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    ConferenceService.this.removeStreamForUser(peer, peerInformation.calculatedMediaStreamType);
                }
            });
        }

        public void onShutdown() {
        }

        public void onIceCandidateDiscovered(String peer, SdpCandidate[] candidates) {
            if (null == ConferenceService.this.getConferenceId()) {
                return;
            }
            Call<ResponseBody> call = ConferenceService.this.mConferenceObservableProvider.candidates(ConferenceService.this.getConferenceId(), peer, new CandidatesPush(candidates));
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.d((String)TAG, (String)"onResponse: Candidates sent ");
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    };
    private CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String s) {
            Log.d((String)TAG, (String)"onCameraError: error...");
            ConferenceService.this.stopVideo().then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: stopped video after camera issue " + result));
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }

        public void onCameraDisconnected() {
            Log.d((String)TAG, (String)"onCameraDisconnected");
        }

        public void onCameraFreezed(String s) {
            Log.d((String)TAG, (String)("onCameraFreezed: " + s));
        }

        public void onCameraOpening(String s) {
            Log.d((String)TAG, (String)("onCameraOpening: " + s));
        }

        public void onFirstFrameAvailable() {
            Log.d((String)TAG, (String)"onFirstFrameAvailable");
        }

        public void onCameraClosed() {
            Log.d((String)TAG, (String)"onCameraClosed");
        }
    };

    private void removeStreamForUser(@NonNull String peer, MediaStreamType mediaStreamType) {
        ConferenceInformation conferenceInformation = this.getCurrentConference();
        User user = this.findUserById(peer);
        if (null != conferenceInformation && null == user) {
            Log.d((String)TAG, (String)("run: WARNING obtained stream for user which did not existed " + peer));
            user = new User(peer, null);
            conferenceInformation.getConference().updateUser(user);
        }
        Log.d((String)TAG, (String)("Remove stream " + mediaStreamType + " for user " + user));
        if (user != null) {
            MediaStream stream = user.streamsHandler().getFirst(mediaStreamType);
            user.streamsHandler().remove(mediaStreamType);
            this.updateConferenceFromUsers();
            this.mEventBus.post((Object)new StreamRemovedEvent(conferenceInformation.getConference(), user, stream));
        } else {
            Log.d((String)TAG, (String)("run: unknown user in stream updated" + Arrays.toString(this.getUsers().toArray())));
        }
    }

    @NoDocumentation
    public ConferenceService(VoxeetSdk instance, long timeout) {
        super(instance, new ServiceProviderHolder.Builder().setRetrofit(instance.getRetrofit()).setService(ISdkConferenceRService.class).setEventBus(instance.getEventBus()).setClient(instance.getClient()).build());
        this.mInstance = instance;
        this.mConferenceObservableProvider = new ConferenceSdkObservableProvider();
        this.mConferenceObservableProvider.setRetrofitInstantiatedProvider((ISdkConferenceRService)this.getService());
        this.mSDK = instance;
        this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout = timeout;
        this.mEventBus = EventBus.getDefault();
        this.mContext = instance.getApplicationContext();
        this.ConferenceConfigurations.automaticTelecomModePrefix = AndroidManifest.readMetadata(this.mContext, "voxeet_automatic_telecom_conference_alias_prefix", null);
        this.registerEventBus();
    }

    public boolean mute(boolean mute) {
        MediaSDK media;
        MediaDeviceService service = VoxeetSdk.mediaDevice();
        MediaSDK mediaSDK = media = null != service ? service.getMedia() : null;
        if (null != media) {
            if (!mute && media.isMuted()) {
                if (!Validate.hasMicrophonePermissions(this.context)) {
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                media.unMute();
            } else if (mute) {
                media.mute();
            }
        }
        return true;
    }

    public boolean isMuted() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        return null == media || media.isMuted();
    }

    @Deprecated
    @NoDocumentation
    public boolean isUserMuted(String userId) {
        return false;
    }

    @Deprecated
    @NoDocumentation
    public void toggleScreenShare() {
        if (this.isScreenShareOn()) {
            this.stopScreenShare().then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onSuccess: toggleScreenShare " + result));
                }
            }).error(this.manageError());
        } else {
            VoxeetSdk.screenShare().sendRequestStartScreenShare();
        }
    }

    @NoDocumentation
    @Nullable
    public String currentSpeaker() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        Conference conference = this.getConference();
        if (null == media || conference == null) {
            return VoxeetSdk.session().getUserId();
        }
        String currentSpeaker = null;
        for (User user : conference.getUsers()) {
            if (user.getId() == null || user.getId().equals(VoxeetPreferences.id()) || !user.isLocallyActive()) continue;
            double peerVuMeter = media.getPeerVuMeter(user.getId());
            if (Double.isNaN(peerVuMeter)) {
                peerVuMeter = 0.0;
            }
            if (currentSpeaker != null && (!(peerVuMeter > 0.001) || !(media.getPeerVuMeter(currentSpeaker) < peerVuMeter))) continue;
            currentSpeaker = user.getId();
        }
        return currentSpeaker;
    }

    public boolean isUserSpeaking(@NonNull User user) {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        Conference conference = this.getConference();
        if (null == media || conference == null) {
            return false;
        }
        double level = this.getLevel(user);
        return level > 0.001;
    }

    @NonNull
    private String currentUserOrEmpty() {
        String currentUserId = VoxeetPreferences.id();
        return null != currentUserId ? currentUserId : "";
    }

    @Nullable
    public User findUserById(String userId) {
        Conference conference = this.getConference();
        return null != conference ? conference.findUserById(userId) : null;
    }

    @NoDocumentation
    @Nullable
    public String getConferenceId() {
        return this.mConferenceId;
    }

    @Deprecated
    @NoDocumentation
    public boolean muteUser(@NonNull String userId, boolean shouldMute) {
        return false;
    }

    private boolean isVideoOn() {
        ConferenceInformation information = this.getCurrentConference();
        return null != information && information.isOwnVideoStarted();
    }

    private boolean isScreenShareOn() {
        ConferenceInformation information = this.getCurrentConference();
        return null != information && information.isScreenShareOn();
    }

    @Deprecated
    @NoDocumentation
    public boolean setDefaultVideo(boolean default_state) {
        return false;
    }

    @Deprecated
    @NoDocumentation
    public boolean setUserPosition(String userId, double angle, double distance) {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            ConferenceInformation conference = this.getCurrentConference();
            if (null != conference) {
                UserPosition position = conference.getPosition(userId);
                position.angle = angle;
                position.distance = distance;
                conference.setPosition(userId, position);
            }
            media.changePeerPosition(userId, angle, distance);
            return true;
        }
        return false;
    }

    @NonNull
    public LocalConferenceType getConferenceType() {
        ConferenceInformation information = this.getCurrentConference();
        if (null == information || null == this.mConferenceId) {
            return LocalConferenceType.NONE;
        }
        return information.getConferenceType();
    }

    @Nullable
    public Conference getConference() {
        ConferenceInformation information = this.getCurrentConference();
        if (null == information) {
            return null;
        }
        return information.getConference();
    }

    public boolean isInConference() {
        return this.mInConference;
    }

    @NoDocumentation
    void setIsInConference(boolean status) {
        this.mInConference = status;
    }

    @NoDocumentation
    public double getLevel(@Nullable String participantId) {
        Validate.runningOnUiThread();
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null == media || null == participantId) {
            return 0.0;
        }
        double peerVuMeter = media.getPeerVuMeter(participantId);
        if (Double.isNaN(peerVuMeter)) {
            peerVuMeter = 0.0;
        }
        return peerVuMeter;
    }

    public double getLevel(@Nullable User participant) {
        if (null != participant && participant.getId() != null && !participant.getId().equals(VoxeetPreferences.id()) && participant.isLocallyActive()) {
            return this.getLevel(participant.getId());
        }
        return 0.0;
    }

    @NoDocumentation
    @NonNull
    public List<User> getUsers() {
        Conference conference = this.getConference();
        if (null == conference) {
            Log.d((String)TAG, (String)"getConferenceUsers: returning a new instance :: NOT IN A CONFERENCE");
            return new ArrayList<User>();
        }
        return conference.getUsers();
    }

    @NoDocumentation
    @NonNull
    public List<User> getLastInvitationUsers() {
        ConferenceInformation information = this.getCurrentConference();
        if (null == information) {
            return new ArrayList<User>();
        }
        return information.getLastInvitationReceived();
    }

    @NoDocumentation
    public boolean isLive() {
        return null != this.getConference();
    }

    @NonNull
    public ConferenceService cancelTimeout() {
        this.removeTimeoutCallbacks();
        return this;
    }

    @NonNull
    public Promise<Boolean> decline(String conferenceId) {
        return new DeclinePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId).createPromise();
    }

    @NoDocumentation
    public void onUserCanceledScreenShare() {
        ConferenceInformation information;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            media.stopScreenCapturer();
        }
        if (null != (information = this.getCurrentConference())) {
            information.setScreenShareOn(false);
        }
    }

    @NoDocumentation
    @NonNull
    Promise<Boolean> startScreenShare(@NonNull Intent intent, int width, int height) {
        return new StartScreensharePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus(), intent, width, height).createPromise();
    }

    @NoDocumentation
    @NonNull
    Promise<Boolean> stopScreenShare() {
        return new StopScreenSharePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @NonNull
    public Promise<Boolean> startVideo() {
        CameraContext provider = VoxeetSdk.mediaDevice().getCameraContext();
        return this.startVideo(provider.isDefaultFrontFacing());
    }

    @NonNull
    public Promise<Boolean> startVideo(boolean isDefaultFrontFacing) {
        return new StartVideoPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus(), isDefaultFrontFacing, this.mConferenceInformationHolder).createPromise();
    }

    public Promise<Boolean> stopVideo() {
        return new StopVideoPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus(), this.mConferenceInformationHolder).createPromise();
    }

    @NoDocumentation
    Promise<Boolean> createVideoAnswer(final @NonNull String userId, final @Nullable OfferDescription offerDescription, final List<OfferCandidate> offerCandidates) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
                String sdp = "";
                String type = "";
                if (null != offerDescription) {
                    sdp = offerDescription.sdp;
                    type = offerDescription.type;
                }
                try {
                    if (null == media) {
                        throw new MediaEngineException("media is null");
                    }
                }
                catch (MediaEngineException exception) {
                    solver.reject(exception);
                }
                if (null == offerDescription) {
                    ConferenceService.this.stopVideo().execute();
                    Log.d((String)TAG, (String)"onCall: unable to start video, are you a listener?");
                    solver.resolve(false);
                    return;
                }
                SdpDescription description = new SdpDescription(type, sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                if (offerCandidates != null) {
                    for (OfferCandidate candidate : offerCandidates) {
                        candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                    }
                }
                ConferenceService.this.createAnswerForPeerThreaded(media, userId, description.ssrc, description, candidates, userId.equals(VoxeetSdk.session().getUserId())).then(new PromiseExec<SdpMessage, Object>(){

                    @Override
                    public void onCall(@Nullable SdpMessage message, @NonNull Solver<Object> internal_solver) {
                        Log.d((String)TAG, (String)("onMessage: having a message " + message));
                        ConferenceService.this.answer(userId, message).then(new PromiseExec<Integer, Object>(){

                            @Override
                            public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                Log.d((String)TAG, (String)("onSuccess: " + result));
                                solver.resolve(true);
                            }
                        }).error(new ErrorPromise(){

                            @Override
                            public void onError(Throwable error) {
                                if (error instanceof PromiseParticipantAddedErrorEventException) {
                                    ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                } else {
                                    error.printStackTrace();
                                }
                                solver.resolve(false);
                            }
                        });
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        solver.reject(error);
                    }
                });
            }
        });
    }

    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).build());
    }

    @Deprecated
    @NoDocumentation
    public Promise<CreateConferenceResult> create(@Nullable String conferenceAlias, @Nullable MetadataHolder metadata, @Nullable ParamsHolder paramsholder) {
        return this.create(new ConferenceCreateInformation.Builder().setConferenceAlias(conferenceAlias).setMetadataHolder(metadata).setParamsHolder(paramsholder).build());
    }

    public Promise<CreateConferenceResult> create(@NonNull ConferenceCreateInformation conferenceCreateInformation) {
        return new CreateConferencePromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus(), conferenceCreateInformation.getConferenceAlias(), conferenceCreateInformation.getMetadataHolder(), conferenceCreateInformation.getParamsHolder()).createPromise();
    }

    public Promise<Boolean> listen(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.LISTENER).build());
    }

    public Promise<Boolean> broadcast(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.BROADCASTER).build());
    }

    public Promise<Boolean> join(@NonNull String conferenceId) {
        return this.join(new ConferenceJoinInformation.Builder(conferenceId).setConferenceUserType(ConferenceUserType.NORMAL).build());
    }

    private Promise<Boolean> join(@NonNull ConferenceJoinInformation conferenceJoinInformation) {
        return new JoinPromise(this, VoxeetSdk.audio(), VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceJoinInformation.getConferenceId()), this.getEventBus(), this.mInstance, conferenceJoinInformation.getConferenceId(), conferenceJoinInformation.getConferenceUserType()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> demo() {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                Call<CreateConferenceResult> user = ConferenceService.this.mConferenceObservableProvider.getCreateDemoObservable();
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<CreateConferenceResult>(){

                    @Override
                    public void onSuccess(@NonNull CreateConferenceResult object, @NonNull Response<CreateConferenceResult> response) {
                        solver.resolve(ConferenceService.this.listen(((CreateConferenceResult)response.body()).conferenceId));
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<CreateConferenceResult> response) {
                        HttpException.dumpErrorResponse(response);
                        solver.reject(e);
                    }
                });
            }
        });
    }

    @NoDocumentation
    @NonNull
    public Promise<List<User>> invite(final String conferenceId, final List<UserInfo> userInfos) {
        return new Promise<List<User>>(new PromiseSolver<List<User>>(){

            @Override
            public void onCall(@NonNull Solver<List<User>> solver) {
                List<User> users = ConferenceService.this.getUsers();
                ArrayList<String> strings = new ArrayList<String>();
                if (null != userInfos) {
                    for (UserInfo info : userInfos) {
                        if (null == info || info.getExternalId() == null) continue;
                        for (int i = 0; i < users.size(); ++i) {
                            User user = users.get(i);
                            if (null == user || null == user.getUserInfo() || !info.getExternalId().equalsIgnoreCase(user.getUserInfo().getExternalId())) continue;
                            user.updateIfNeeded(info.getName(), info.getAvatarUrl());
                        }
                        strings.add(info.getExternalId());
                    }
                }
                solver.resolve(new InvitePromise(ConferenceService.this, VoxeetSdk.mediaDevice(), ConferenceService.this.mConferenceObservableProvider, ConferenceService.this.getCurrentConference(), ConferenceService.this.getEventBus(), conferenceId, strings).createPromise());
            }
        });
    }

    public Promise<Boolean> replay(String conferenceId, long offset) {
        return new ReplayPromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus(), conferenceId, offset).createPromise();
    }

    public Promise<ConferenceStatusResult> getConferenceStatus(String conferenceId) {
        return new GetConferenceStatusPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<ConferenceHistoryResult> conferenceHistory(String conferenceId) {
        return new GetConferenceHistoryPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> subscribe(@NonNull String conferenceId) {
        return new SubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> unSubscribe(@NonNull String conferenceId) {
        return new UnsubscribeConferenceEventPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> subscribeForCall(String conferenceId) {
        return new SubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NoDocumentation
    public Promise<Boolean> unSubscribeFromCall(String conferenceId) {
        return new UnsubscribeForCallStartPromiseable(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(PushConferenceDestroyed event) {
        EventBus.getDefault().post((Object)new ConferenceDestroyedPush(event.conferenceId));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull OwnConferenceUserSwitch switchEvent) {
        Log.d((String)TAG, (String)("onEvent: OwnConferenceUserSwitch : type ? " + switchEvent.getType()));
        if (this.isLive()) {
            this.leave().then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)"onCall: on leave for switch user");
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    Log.d((String)TAG, (String)"onError: on leave for switch user");
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(@NonNull SocketStateChangeEvent event) {
        if (WebSocketState.CONNECTED.equals((Object)event.state)) {
            String conferenceId = this.getConferenceId();
            ConferenceInformation information = this.getCurrentConference();
            if (null != conferenceId && null != information && ConferenceState.JOINED.equals((Object)information.getConferenceState())) {
                if (this.ConferenceConfigurations.isICERestartEnabled) {
                    Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined <3");
                    Call<ResponseBody> user = this.mConferenceObservableProvider.iceRestart(conferenceId);
                    HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                        @Override
                        public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                            Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined responded <3");
                        }

                        @Override
                        public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                            Log.d((String)TAG, (String)"onEvent: SocketConnectEvent Joined error </3");
                            HttpException.dumpErrorResponse(response);
                        }
                    });
                } else {
                    Log.d((String)TAG, (String)"onEvent: socket state opened while in conference but no isICERestartEnabled() = true. A reconnect may be longer");
                }
            } else {
                ConferenceState state = ConferenceState.DEFAULT;
                if (null != information) {
                    state = information.getConferenceState();
                }
                Log.d((String)TAG, (String)("onEvent: SocketConnectEvent not rejoined </3 " + (Object)((Object)state) + " " + conferenceId));
            }
        }
    }

    @NonNull
    private Promise<Boolean> joinVoxeetConference(final @NonNull String conferenceId) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                String existingConferenceId = ConferenceService.this.getConferenceId();
                Log.d((String)TAG, (String)("onCall: " + ConferenceService.this.mInConference + " " + existingConferenceId + " " + conferenceId));
                if (ConferenceService.this.mInConference && (null == existingConferenceId || !existingConferenceId.equals(conferenceId))) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                ConferenceInformation information = ConferenceService.this.getCurrentConference();
                if (null != information) {
                    solver.resolve(ConferenceService.this.joinConferenceInternalPackage(information));
                } else {
                    Log.d((String)TAG, (String)"onCall: WARNING :: IMPROPER RESULT !!");
                    solver.resolve(false);
                }
            }
        });
    }

    @NoDocumentation
    void setCurrentConferenceIfNotInPreviousConference(@NonNull ConferenceInformation conference) {
        boolean canOverride;
        String conferenceId = conference.getConference().getId();
        boolean invalidId = null == conferenceId;
        boolean inConference = this.isInConference();
        boolean sameConference = null == this.mConferenceId || this.mConferenceId.equals(conferenceId);
        boolean bl = canOverride = !inConference || sameConference;
        if (!invalidId && canOverride) {
            this.mConferenceId = conferenceId;
        }
        Log.d((String)TAG, (String)("setCurrentConferenceIfNotInPreviousConference:  invalidId = " + invalidId + " inConference = " + inConference + " sameConference = " + sameConference + " (" + this.mConferenceId + " " + conferenceId + ")  canOverride = " + canOverride + " mConferenceId = " + this.mConferenceId));
    }

    @NonNull
    @NoDocumentation
    Promise<Boolean> joinConferenceInternalPackage(final @NonNull ConferenceInformation conference) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                String conferenceId = conference.getConference().getId();
                boolean invalidId = null == conferenceId;
                boolean inConference = ConferenceService.this.isInConference();
                boolean sameConference = null == ConferenceService.this.mConferenceId || ConferenceService.this.mConferenceId.equals(conferenceId);
                Log.d((String)TAG, (String)("onCall: join conference " + conference + " invalidId:=" + invalidId + " inConference:=" + inConference + " sameConference:=" + sameConference + " canOverride:=" + (inConference && !sameConference) + " mConferenceId:=" + ConferenceService.this.mConferenceId + " conferenceId:=" + conferenceId));
                Log.d((String)TAG, (String)"onCall: Not checking for conference joined. Method internally used -- in case of regression please contact support for this specific");
                if (invalidId) {
                    try {
                        throw new InConferenceException();
                    }
                    catch (InConferenceException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.removeTimeoutCallbacks();
                Log.d((String)TAG, (String)("joining " + conferenceId));
                ConferenceService.this.setIsInConference(true);
                ConferenceService.this.mConferenceId = conferenceId;
                conference.setConferenceState(ConferenceState.JOINING);
                AudioService service = VoxeetSdk.audio();
                if (null != service) {
                    service.enableAec(true);
                    service.enableNoiseSuppressor(true);
                }
                boolean isSuccess = ConferenceService.this.initMedia(conference.isListener());
                Conference correspondingConference = conference.getConference();
                if (!isSuccess) {
                    Log.d((String)TAG, (String)"onCall: InitMedia failed... new state = left");
                    try {
                        ConferenceService.this.setIsInConference(false);
                        conference.setConferenceState(ConferenceState.LEFT);
                        ConferenceService.this.closeMedia();
                        ConferenceStateEvent error = new ConferenceStateEvent(correspondingConference, correspondingConference.getState());
                        ConferenceService.this.mEventBus.post((Object)error);
                        throw new PromiseConferenceJoinedErrorException(error, null);
                    }
                    catch (PromiseConferenceJoinedErrorException exception) {
                        solver.reject(exception);
                        return;
                    }
                }
                ConferenceService.this.mEventBus.post((Object)new ConferenceStateEvent(correspondingConference, correspondingConference.getState()));
                Call<ResumeConference> user = ConferenceService.this.mConferenceObservableProvider.joinConference(conferenceId, new JoinParameters(DeviceType.ANDROID, conference.isListener()));
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResumeConference>(){

                    @Override
                    public void onSuccess(@NonNull ResumeConference object, @NonNull Response<ResumeConference> response) {
                        ConferenceService.this.createOrSetConferenceWithParams(object.getConferenceId(), object.getConferenceAlias());
                        ConferenceService.this.initMedia(conference.isListener());
                        String automaticTelecomModePrefix = ConferenceService.this.ConferenceConfigurations.automaticTelecomModePrefix;
                        boolean hasAutomaticPrefix = null != automaticTelecomModePrefix && !TextUtils.isEmpty((CharSequence)automaticTelecomModePrefix);
                        Log.d((String)TAG, (String)("onSuccess: trying to join conference, will an attempt to be telecom be made ? " + hasAutomaticPrefix));
                        ConferenceInformation information = ConferenceService.this.getCurrentConference();
                        if (null != information) {
                            if (hasAutomaticPrefix && !TextUtils.isEmpty((CharSequence)object.getConferenceAlias()) && object.getConferenceAlias().startsWith(automaticTelecomModePrefix)) {
                                Log.d((String)TAG, (String)"onSuccess: the conference is now in telecom mode");
                                information.setTelecomMode(true);
                            } else {
                                Log.d((String)TAG, (String)"onSuccess: the prefix does not match - if the telecom mode is required, it must be done programmatically at this point");
                            }
                            information.setConferenceState(ConferenceState.JOINED);
                        }
                        ConferenceService.this.onConferenceResumedInternal(object, solver);
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResumeConference> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            e.printStackTrace();
                            ConferenceService.this.setIsInConference(false);
                            conference.setConferenceState(ConferenceState.LEFT);
                            ConferenceService.this.closeMedia();
                            Conference correspondingConference = conference.getConference();
                            ConferenceStateEvent event = new ConferenceStateEvent(correspondingConference, correspondingConference.getState());
                            ConferenceService.this.getEventBus().post((Object)event);
                            throw new PromiseConferenceJoinedErrorException(event, e);
                        }
                        catch (PromiseConferenceJoinedErrorException exception) {
                            solver.reject(exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    private void onConferenceResumedInternal(@NonNull ResumeConference response, final @NonNull Solver<Boolean> solver) {
        this.mConferenceId = response.getConferenceId();
        ConferenceInformation information = this.getCurrentConference();
        Conference conference = information.getConference();
        conference.setConferenceId(response.getConferenceId());
        conference.setConferenceAlias(response.getConferenceId());
        if (response.getConferenceAlias() != null) {
            conference.setConferenceAlias(response.getConferenceAlias());
        }
        information.participantsToConferenceUsers(response.getParticipants());
        this.setIsInConference(true);
        VoxeetSdk.audio().setAudioRoute(AudioRoute.ROUTE_PHONE);
        this.mEventBus.post((Object)new ConferenceStateEvent(conference, conference.getState()));
        List<Participant> participants = response.getParticipants();
        int length = null != participants ? participants.size() : -1;
        Log.d((String)TAG, (String)("onConferenceResumedInternal: resuming with participants ? " + participants + " " + length));
        if (null != participants) {
            for (Participant participant : participants) {
                Log.d((String)TAG, (String)("onConferenceResumedInternal: call onUserAddedOrUpdated " + participant));
                this.onUserAddedOrUpdated(conference.getId(), participant.getParticipantId(), participant.getUserInfos(), ConferenceUserStatus.fromString(participant.getStatus()), true);
            }
        }
        if (null == response.getCandidates() && null == response.getDescription()) {
            Log.d((String)TAG, (String)"onConferenceResumedInternal: candidates + description");
            solver.resolve(true);
            return;
        }
        Log.d((String)TAG, (String)"onConferenceResumedInternal: having candidates and description");
        UserInfo info = VoxeetSdk.session().getUserInfo();
        String name = "";
        String externalId = "";
        String avatarUrl = "";
        String userId = "";
        if (null != info) {
            userId = VoxeetPreferences.id();
            name = info.getName();
            externalId = info.getExternalId();
            avatarUrl = info.getAvatarUrl();
        }
        this.handleAnswer(response.getConferenceId(), userId != null ? userId : "", externalId, name, avatarUrl, "ANDROID", true, response.getDescription(), response.getCandidates()).then(new PromiseExec<Boolean, Object>(){

            @Override
            public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> s) {
                Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + VoxeetPreferences.id()));
                solver.resolve(true);
            }
        }).error(new ErrorPromise(){

            @Override
            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
                ExceptionManager.sendException(error);
                solver.reject(error);
            }
        });
    }

    @NonNull
    public Promise<ConferenceUsersInvitedResult> getInvitedUsers(@NonNull String conferenceId) {
        return new GetConferenceStatus(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getConferenceInformation(conferenceId), this.getEventBus()).createPromise();
    }

    @NonNull
    public Promise<Boolean> leave() {
        return new LeavePromise(this, VoxeetSdk.mediaDevice(), this.mConferenceObservableProvider, this.getCurrentConference(), this.getEventBus()).createPromise();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(InvitationReceivedEvent invitation) {
        String conferenceId = invitation.conferenceId;
        if (null == conferenceId && null != invitation.conference) {
            conferenceId = invitation.conference.getConferenceId();
        }
        Log.d((String)TAG, (String)("onEvent: current mConferenceId " + this.mConferenceId + " vs " + invitation.conferenceId + " vs " + conferenceId));
        if (null != this.mConferenceId && this.mConferenceId.equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for our conference, we prevent this");
            return;
        }
        final ConferenceInformation information = this.getConferenceInformation(conferenceId);
        boolean is_own_user = invitation.userId.equals(VoxeetPreferences.id());
        ConferenceType type = ConferenceType.fromId(invitation.conference.getConferenceType());
        if (this.isLive() && null != this.getConferenceId() && this.getConferenceId().equals(conferenceId)) {
            Log.d((String)TAG, (String)"onEvent: receiving invitation for the same conference, invalidate the call");
            return;
        }
        if (!is_own_user || ConferenceType.SCHEDULED.equals((Object)type)) {
            InvitationReceivedEvent.UserInviter inviter = invitation.getInviter();
            List<Invitation> invitations = invitation.invitations;
            final User[] foundUser = new User[]{null};
            if (null == information) {
                Log.d((String)TAG, (String)"onEvent: INVALID INFORMATION FOR THE CONFERENCE");
            }
            if (null != inviter && null != inviter.externalId && null != inviter.userId) {
                User inviter_user;
                Log.d((String)TAG, (String)("onEvent: Invitation with inviter " + inviter.userId + " " + inviter.externalId));
                UserInfo info = new UserInfo(inviter.nickName, inviter.externalId, inviter.externalAvatarUrl);
                foundUser[0] = inviter_user = new User(inviter.userId, info);
                if (null != information) {
                    information.getLastInvitationReceived().add(inviter_user);
                    information.getUserIdsCached().put(inviter.userId, inviter.externalId);
                }
            } else {
                Log.d((String)TAG, (String)"onEvent: Invitation with invalid inviter");
            }
            this.getConferenceStatus(invitation.conference.getConferenceId()).then(new PromiseExec<ConferenceStatusResult, Object>(){

                @Override
                public void onCall(@Nullable ConferenceStatusResult result, @NonNull Solver<Object> internal_solver) {
                    Log.d((String)TAG, (String)("onSuccess: " + result));
                    if (result.getConferenceUsers().size() > 0) {
                        Log.d((String)TAG, (String)("onEvent: users " + result.getConferenceUsers().size()));
                        String foundExternalId = null;
                        ArrayList<User> merged_list = new ArrayList<User>();
                        for (SdkParticipant sdkParticipant : result.participants) {
                            merged_list.add(new User(sdkParticipant));
                        }
                        merged_list.addAll(ConferenceService.this.getLastInvitationUsers());
                        List<User> list = ConferenceUtils.findUsersMatching(ConferenceService.this.currentUserOrEmpty(), merged_list);
                        for (User conferenceUser : list) {
                            String userId = conferenceUser.getId();
                            if (null != foundExternalId || null == information) continue;
                            String externalId = conferenceUser.getUserInfo().getExternalId();
                            String cachedExternalId = information.getUserIdsCached().get(userId);
                            Log.d((String)TAG, (String)("onEvent: " + userId + " " + externalId + " " + cachedExternalId));
                            if (null == foundUser[0]) {
                                foundUser[0] = conferenceUser;
                            }
                            if (null == userId || null != externalId && !userId.equals(externalId) || null == (externalId = cachedExternalId)) continue;
                            foundExternalId = cachedExternalId;
                        }
                        if (foundUser[0] != null && null == foundExternalId) {
                            foundExternalId = foundUser[0].getId();
                            Log.d((String)TAG, (String)"externalId is null, setting it to userId");
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (null != foundUser[0]) {
                            // empty if block
                        }
                        hashMap.put("UserId", null != foundUser[0] ? foundUser[0].getId() : "");
                        hashMap.put("DisplayName", null != foundUser[0] ? foundUser[0].getUserInfo().getName() : "");
                        hashMap.put("NotifType", null != result.getType() ? result.getType() : "");
                        hashMap.put("ExternalId", null != foundUser[0] ? foundExternalId : "");
                        hashMap.put("AvatarUrl", null != foundUser[0] ? foundUser[0].getUserInfo().getAvatarUrl() : "");
                        hashMap.put("ConfId", null != result.conferenceId ? result.conferenceId : "");
                        NotificationService notificationService = VoxeetSdk.notification();
                        if (null != notificationService) {
                            notificationService.onInvitationReceived(ConferenceService.this.context, new InvitationBundle(hashMap));
                        }
                        ConferenceService.this.mEventBus.post((Object)new IncomingCallEvent(result.conferenceId));
                    }
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(OwnConferenceCreated ownConferenceStartedEvent) {
        Conference conference;
        if (null != ownConferenceStartedEvent.conferenceInfos) {
            this.mConferenceId = ownConferenceStartedEvent.conferenceInfos.getConferenceId();
        }
        if (null != (conference = this.getConference())) {
            conference.setConferenceInfos(ownConferenceStartedEvent.conferenceInfos);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(RenegociationEndedEvent event) {
        Log.d((String)TAG, (String)("onEvent: Renegociation " + event.getConferenceId() + " " + event.getType() + " " + event.getAnswerReceived() + " " + event.getOfferSent()));
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(final OfferCreated offer) {
        String conferenceId;
        Conference conference = this.getConference();
        String string2 = conferenceId = null != conference ? conference.getId() : null;
        if (null != conferenceId && conferenceId.equals(offer.getConferenceId())) {
            User user = this.findUserById(offer.getUserId());
            if (null == user) {
                user = new User(offer.getUserId(), new UserInfo(offer.getName(), offer.getExternalId(), offer.getAvatarUrl()));
                Log.d((String)TAG, (String)("run: WARNING obtained OfferCreated for user which did not existed " + user));
                conference.updateUser(user);
                this.mEventBus.post((Object)new UserAddedEvent(conference, user));
            }
            this.handleAnswer(offer.getConferenceId(), offer.getUserId(), offer.getExternalId(), offer.getName(), offer.getAvatarUrl(), offer.getDevice(), offer.isMaster(), offer.getDescription(), offer.getCandidates()).then(new PromiseExec<Boolean, Object>(){

                @Override
                public void onCall(@Nullable Boolean aBoolean, @NonNull Solver<Object> solver) {
                    Log.d((String)TAG, (String)("onCall: answer called, result is " + aBoolean + " " + offer.getUserId() + " " + VoxeetPreferences.id()));
                }
            }).error(new ErrorPromise(){

                @Override
                public void onError(@NonNull Throwable error) {
                    error.printStackTrace();
                    ExceptionManager.sendException(error);
                }
            });
        } else {
            Log.d((String)TAG, (String)"onEvent: OfferCreated for another conference");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantAdded event) {
        this.onUserAddedOrUpdated(event.conferenceId, event.userId, new UserInfo(event.name, event.externalId, event.avatarUrl), ConferenceUserStatus.fromString(event.status), true);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(ParticipantUpdated event) {
        this.onUserAddedOrUpdated(event.conferenceId, event.userId, null, ConferenceUserStatus.valueOf(event.status), false);
    }

    private void onUserAddedOrUpdated(@NonNull String conferenceId, @NonNull String userId, @Nullable UserInfo userInfo, @NonNull ConferenceUserStatus status, boolean added) {
        boolean timeout_triggered;
        boolean known_user = false;
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        Conference conference = null;
        User user = this.findUserById(userId);
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        if (null != information) {
            conference = information.getConference();
            user = conference.findUserById(userId);
            if (null != user) {
                known_user = true;
                if (added && null != userInfo) {
                    user.setUserInfo(userInfo);
                }
            } else {
                user = new User(userId, userInfo);
                conference.updateUser(user);
            }
        }
        if (user != null) {
            user.updateStatus(status);
        }
        this.updateConferenceFromUsers();
        switch (status) {
            case CONNECTING: {
                if (null == user || user.getId().equals(VoxeetSdk.session().getUserId())) break;
                Log.d((String)TAG, (String)"Cancelling timeout timer from user connecting");
                this.removeTimeoutCallbacks();
                break;
            }
            case LEFT: 
            case DECLINE: {
                if (null == media || user == null) break;
                user.streamsHandler().removeAllStreams();
                Log.d((String)TAG, (String)("In mConference user with id: " + user + " status updated to " + (Object)((Object)status)));
                media.removePeer(userId);
                break;
            }
            default: {
                Log.d((String)TAG, (String)("status not managed updated to " + (Object)((Object)status)));
            }
        }
        boolean bl = timeout_triggered = null != this.timeoutRunnable && this.timeoutRunnable.isTriggered();
        if (!timeout_triggered) {
            switch (status) {
                case DECLINE: {
                    if (!userId.equals(VoxeetSdk.session().getUserId())) {
                        Log.d((String)TAG, (String)("Conference user with id: " + userId + " declined the call"));
                        this.checkForTelecomEvent(conferenceId, userId);
                        this.mEventBus.post((Object)new UserUpdatedEvent(conference, user));
                        break;
                    }
                }
                case LEFT: {
                    this.checkForTelecomEvent(conference.getId(), user.getId());
                }
                default: {
                    this.updateConferenceFromUsers();
                    if (known_user) {
                        this.mEventBus.post((Object)new UserUpdatedEvent(conference, user));
                        break;
                    }
                    this.mEventBus.post((Object)new UserAddedEvent(conference, user));
                }
            }
        }
    }

    private void checkForTelecomEvent(String conferenceId, String userId) {
        ConferenceInformation currentConference = this.getCurrentConference();
        Log.d((String)TAG, (String)("checkForTelecomEvent: having currentConference ? " + currentConference));
        if (null != currentConference && currentConference.isTelecomMode()) {
            Conference conference = currentConference.getConference();
            if (null != conferenceId && conferenceId.equals(conference.getId())) {
                String id = VoxeetPreferences.id();
                if (!TextUtils.isEmpty((CharSequence)userId) && null != id && !id.equals(userId)) {
                    this.leave().then(new PromiseExec<Boolean, Object>(){

                        @Override
                        public void onCall(@Nullable Boolean result, @NonNull Solver<Object> solver) {
                            Log.d((String)TAG, (String)"onCall: conference left since declined/left event");
                        }
                    }).error(new ErrorPromise(){

                        @Override
                        public void onError(@NonNull Throwable error) {
                            Log.e((String)TAG, (String)"onError: conference left since declined/left event", (Throwable)error);
                        }
                    });
                }
            }
        } else {
            Log.d((String)TAG, (String)"checkForTelecomEvent: not a telecom mode");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceDestroyedPush event) {
        this.onEndOrDestroyed(event.conferenceId, ConferenceState.DESTROYED);
    }

    @Subscribe(threadMode=ThreadMode.MAIN, priority=999)
    public void onEvent(ConferenceEnded event) {
        this.onEndOrDestroyed(event.conferenceId, ConferenceState.ENDED);
    }

    private void onEndOrDestroyed(@Nullable String eventConfId, ConferenceState newStatus) {
        String conferenceId = this.mConferenceId;
        ConferenceInformation information = this.getCurrentConference();
        if (null != information && !TextUtils.isEmpty((CharSequence)information.getConference().getId())) {
            conferenceId = information.getConference().getId();
        }
        if (!TextUtils.isEmpty((CharSequence)conferenceId) && conferenceId.equals(eventConfId)) {
            information.setConferenceState(newStatus);
            this.closeMedia();
            this.mEventBus.post((Object)new ConferenceStateEvent(information.getConference(), newStatus));
        } else {
            Log.d((String)TAG, (String)"onEvent: another conference has ended");
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEvent(QualityUpdated event) {
        for (ConferenceUser conferenceUser : event.user) {
            User user = this.findUserById(conferenceUser.getUserId());
            if (user == null) continue;
            user.setQuality(conferenceUser.getQuality());
            this.mEventBus.post((Object)new ConferenceUserQualityUpdatedEvent(user));
        }
    }

    @NoDocumentation
    @NonNull
    protected User createConferenceUser(String userId, String device, UserInfo userInfo) {
        return new User(userId, userInfo);
    }

    @NoDocumentation
    protected void setConference(@NonNull Conference conference) {
        this.mConferenceId = conference.getId();
        ConferenceInformation information = this.getCurrentConference();
        information.setConference(conference);
    }

    @NoDocumentation
    protected void setConferenceAlias(String alias) {
        Conference conference = this.getConference();
        conference.setConferenceAlias(alias);
    }

    @NoDocumentation
    protected boolean isSDK() {
        return true;
    }

    @NoDocumentation
    protected Promise<Integer> answer(final String peer, final SdpMessage message) {
        return new Promise<Integer>(new PromiseSolver<Integer>(){

            @Override
            public void onCall(final @NonNull Solver<Integer> solver) {
                try {
                    if (null == ConferenceService.this.mConferenceId) {
                        throw new NotInConferenceException();
                    }
                }
                catch (NotInConferenceException exception) {
                    solver.reject(exception);
                    return;
                }
                if (null == message) {
                    try {
                        ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent("Invalid message");
                        throw new PromiseParticipantAddedErrorEventException(event);
                    }
                    catch (PromiseParticipantAddedErrorEventException exception) {
                        solver.reject(exception);
                    }
                }
                Log.d((String)"SDKMEDIA", (String)("answer: peer := " + peer + " message := " + message));
                Call<ResponseBody> user = ConferenceService.this.mConferenceObservableProvider.answerConference(ConferenceService.this.mConferenceId, peer, message.getDescription());
                HttpHelper.enqueue(user, new HttpHelper.HttpCallback<ResponseBody>(){

                    @Override
                    public void onSuccess(@NonNull ResponseBody object, @NonNull Response<ResponseBody> response) {
                        if (response.code() != 200) {
                            try {
                                ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(response.code() + "");
                                throw new PromiseParticipantAddedErrorEventException(event);
                            }
                            catch (PromiseParticipantAddedErrorEventException exception) {
                                solver.reject(exception);
                            }
                        } else {
                            solver.resolve(response.code());
                        }
                    }

                    @Override
                    public void onFailure(@NonNull Throwable e, @Nullable Response<ResponseBody> response) {
                        HttpException.dumpErrorResponse(response);
                        try {
                            ParticipantAddedErrorEvent event = new ParticipantAddedErrorEvent(ConferenceService.this.handleError(e));
                            throw new PromiseParticipantAddedErrorEventException(event);
                        }
                        catch (PromiseParticipantAddedErrorEventException exception) {
                            solver.reject(exception);
                            return;
                        }
                    }
                });
            }
        });
    }

    @NoDocumentation
    protected Promise<Boolean> handleAnswer(final @NonNull String conferenceId, final @NonNull String userId, final @NonNull String externalId, final @NonNull String userName, final @NonNull String avatarUrl, @NonNull String device, final boolean isMaster, final @NonNull OfferDescription offerDescription, final @NonNull List<OfferCandidate> offerCandidates) {
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(final @NonNull Solver<Boolean> solver) {
                MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
                if (null == media) {
                    try {
                        throw new MediaEngineException("handleAnswer media is null");
                    }
                    catch (MediaEngineException exception) {
                        solver.reject(exception);
                    }
                }
                if (!conferenceId.equals(ConferenceService.this.mConferenceId)) {
                    Log.d((String)TAG, (String)"onCall: CONFERENCE IS NOT THE SAME ! ANSWER SHALL BE DISCARDED");
                }
                SdpDescription description = new SdpDescription(offerDescription.type, offerDescription.sdp);
                ArrayList<SdpCandidate> candidates = new ArrayList<SdpCandidate>();
                for (OfferCandidate candidate : offerCandidates) {
                    Log.d((String)TAG, (String)("onCall: sdpcandidate " + candidate.getMid() + " " + candidate.getmLine()));
                    candidates.add(new SdpCandidate(candidate.getMid(), Integer.parseInt(candidate.getmLine()), candidate.getSdp()));
                }
                Log.d((String)TAG, (String)("handleAnswer: offer := " + userId + " " + externalId));
                Log.d((String)"SDKMEDIA", (String)("handleAnswer: " + userId + " " + externalId + " " + description.ssrc));
                ConferenceService.this.createAnswerForPeerThreaded(media, userId, description.ssrc, description, candidates, isMaster).then(new PromiseExec<SdpMessage, Object>(){

                    @Override
                    public void onCall(@Nullable SdpMessage message, @NonNull Solver<Object> internal_solver) {
                        try {
                            if (null == ConferenceService.this.mConferenceId) {
                                Log.d((String)TAG, (String)"onMessage: INVALID CONFERENCE ID WHEN OFFER IS RECEIVED");
                                ConferenceService.this.mConferenceId = conferenceId;
                            }
                            Conference conference = ConferenceService.this.getConference();
                            User user = null;
                            for (User in_conf : conference.getUsers()) {
                                if (in_conf.getId() == null || !in_conf.getId().equals(userId)) continue;
                                user = in_conf;
                            }
                            UserInfo infos = userId.contains("11111") ? new UserInfo("Julie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_1.png") : (userId.contains("22222") ? new UserInfo("Sophie", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_2.png") : (userId.contains("33333") ? new UserInfo("Mike", externalId, "https://raw.githubusercontent.com/romainbenmansour/JCenter/master/user_3.png") : new UserInfo(userName, externalId, avatarUrl)));
                            if (user == null) {
                                user = new User(userId, infos);
                                conference.updateUser(user);
                            } else {
                                user.setUserInfo(infos);
                            }
                            ConferenceService.this.setUserPosition(userId, 0.0, 0.5);
                            ConferenceService.this.answer(userId, message).then(new PromiseExec<Integer, Object>(){

                                @Override
                                public void onCall(@Nullable Integer result, @NonNull Solver<Object> internal_solver) {
                                    Log.d((String)TAG, (String)("onSuccess: " + result));
                                    solver.resolve(true);
                                }
                            }).error(new ErrorPromise(){

                                @Override
                                public void onError(Throwable error) {
                                    if (error instanceof PromiseParticipantAddedErrorEventException) {
                                        ConferenceService.this.mEventBus.post((Object)((PromiseParticipantAddedErrorEventException)error).getEvent());
                                    } else {
                                        error.printStackTrace();
                                    }
                                    solver.resolve(false);
                                }
                            });
                        }
                        catch (Exception e) {
                            Log.d((String)TAG, (String)("onMessage: unlockPeerOperation" + e.getMessage()));
                            solver.resolve(false);
                        }
                    }
                }).error(new ErrorPromise(){

                    @Override
                    public void onError(@NonNull Throwable error) {
                        error.printStackTrace();
                        solver.reject(error);
                    }
                });
            }
        });
    }

    @NoDocumentation
    protected User updateConferenceParticipants(String userId, ConferenceUserStatus status) {
        User user = this.findUserById(userId);
        Conference conference = this.getConference();
        if (null != user && null != conference) {
            user.updateStatus(status);
            return user;
        }
        return null;
    }

    @NoDocumentation
    protected boolean initMedia(boolean listenerMode) {
        Validate.notNull(this.mContext, "mContext");
        Validate.notNull(VoxeetPreferences.id(), "user id");
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null == media) {
            try {
                if (!listenerMode && !Validate.hasMicrophonePermissions(this.context)) {
                    Log.d((String)TAG, (String)"the app does not seem to have mic permission, disabling mic");
                    this.mute(true);
                    this.getEventBus().post((Object)new PermissionRefusedEvent(PermissionRefusedEvent.Permission.MICROPHONE));
                    return false;
                }
                AudioService audioService = VoxeetSdk.audio();
                MediaDeviceService mediaDeviceService = VoxeetSdk.mediaDevice();
                if (null == audioService || null == mediaDeviceService) {
                    throw new IllegalStateException("Invalid services state");
                }
                audioService.enable();
                mediaDeviceService.createMedia(this.context, VoxeetPreferences.id(), this.mediaStreamListener, this.cameraEventsHandler, this.ConferenceConfigurations.isDefaultVideo || this.isVideoOn(), !listenerMode && Validate.hasMicrophonePermissions(this.context));
                media = mediaDeviceService.getMedia();
                audioService.setSpeakerMode(this.ConferenceConfigurations.isDefaultOnSpeaker);
                audioService.unsetMediaRoute().requestAudioFocus();
                if (null != media) {
                    if (this.ConferenceConfigurations.isDefaultMute) {
                        media.mute();
                    } else {
                        media.unMute();
                    }
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return false;
            }
            catch (MediaEngineException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @NoDocumentation
    protected void closeMedia() {
        MediaSDK media = VoxeetSdk.mediaDevice().getMedia();
        if (null != media) {
            Conference conference = this.getConference();
            ConferenceInformation information = this.getCurrentConference();
            if (null != information) {
                information.setRequestedOwnVideo(false);
                information.setScreenShareOn(false);
                information.setConferenceState(ConferenceState.LEFT);
            }
            try {
                if (null != conference) {
                    for (User user : conference.getUsers()) {
                        if (user == null || user.getId() == null) continue;
                        media.removePeer(user.getId());
                    }
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Error", (Throwable)ex);
            }
            VoxeetSdk.audio().abandonAudioFocusRequest().setMediaRoute().disable();
            VoxeetSdk.mediaDevice().releaseMedia();
            media.unsetStreamListener();
        }
        this.setIsInConference(false);
        this.mConferenceId = null;
    }

    @NoDocumentation
    protected void removeTimeoutCallbacks() {
        if (this.timeoutRunnable != null) {
            this.timeoutRunnable.setCanceled(true);
            handler.removeCallbacks((Runnable)this.timeoutRunnable);
        }
    }

    @NoDocumentation
    protected void sendTimeoutCallbacks() {
        if (this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout != -1L) {
            this.timeoutRunnable = new TimeoutRunnable(this, this.mEventBus, this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout);
            handler.postDelayed((Runnable)this.timeoutRunnable, this.ConferenceConfigurations.TelecomWaitingForParticipantTimeout);
        }
    }

    @NoDocumentation
    protected VoxeetSdk getVoxeetSDK() {
        return this.mSDK;
    }

    @NonNull
    @NoDocumentation
    protected ConferenceInformation createOrSetConferenceWithParams(@NonNull String conferenceId, @Nullable String conferenceAlias) {
        Log.d((String)TAG, (String)("createOrSetConferenceWithParams: set conference id := " + conferenceId));
        ConferenceInformation information = this.getConferenceInformation(conferenceId);
        Conference conference = information.getConference();
        conference.setConferenceId(conferenceId);
        if (null != conferenceAlias || null == conference.getAlias()) {
            conference.setConferenceAlias(conferenceAlias);
        }
        return information;
    }

    @Nullable
    public ConferenceInformation getCurrentConference() {
        if (null == this.mConferenceId) {
            return null;
        }
        return this.getConferenceInformation(this.mConferenceId);
    }

    public boolean hasParticipants() {
        Conference conference = this.getConference();
        if (null == conference) {
            return false;
        }
        if (conference.hasLocalStreams(false)) {
            return true;
        }
        return conference.hasAny(ConferenceUserStatus.ON_AIR, false);
    }

    @NonNull
    @NoDocumentation
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    public ConferenceInformation getConferenceInformation(@NonNull String conferenceId) {
        return this.mConferenceInformationHolder.getInformation(conferenceId);
    }

    @NoDocumentation
    void joinLock() {
        try {
            this.joinLock.lock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NoDocumentation
    void joinUnlock() {
        try {
            if (this.joinLock.isLocked()) {
                this.joinLock.unlock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateConferenceFromUsers() {
        ConferenceInformation information = this.getCurrentConference();
        if (null != information) {
            ConferenceState state = information.getConferenceState();
            switch (state) {
                case JOINED: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
                case FIRST_PARTICIPANT: {
                    if (this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.NO_MORE_PARTICIPANT);
                    break;
                }
                case NO_MORE_PARTICIPANT: {
                    if (!this.hasParticipants()) break;
                    information.setConferenceState(ConferenceState.FIRST_PARTICIPANT);
                    break;
                }
            }
            ConferenceState conferenceState = information.getConferenceState();
        }
    }

    @NonNull
    private ErrorPromise manageError() {
        return new ErrorPromise(){

            @Override
            public void onError(@NonNull Throwable error) {
                error.printStackTrace();
            }
        };
    }

    @Nullable
    private String getUserId() {
        SessionService sessionService = VoxeetSdk.session();
        return null != sessionService ? sessionService.getUserId() : null;
    }

    @NoDocumentation
    void clearConferencesInformation() {
        this.mConferenceInformationHolder.clearConferencesInformation();
    }

    @NoDocumentation
    public void moveConference(@NonNull String conferenceId, @NonNull ConferenceInformation conferenceInformation) {
        Log.d((String)TAG, (String)("moveConference: change " + conferenceInformation.getConference().getId() + " to " + conferenceId));
        this.mConferenceInformationHolder.moveConference(conferenceId, conferenceInformation);
    }

    private Promise<SdpMessage> createAnswerForPeerThreaded(final @NonNull MediaSDK media, final @NonNull String userId, final long ssrc, final @NonNull SdpDescription offer, final @NonNull List<SdpCandidate> candidates, final boolean master) {
        return new Promise<SdpMessage>(new PromiseSolver<SdpMessage>(){

            @Override
            public void onCall(final @NonNull Solver<SdpMessage> solver) {
                ConferenceService.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            media.createAnswerForPeer(userId, ssrc, offer, candidates, master, new PendingPeerCallback(){

                                @Override
                                public void onMessage(@Nullable SdpMessage message) {
                                    solver.resolve(message);
                                }
                            });
                        }
                        catch (MediaEngineException e) {
                            e.printStackTrace();
                            solver.reject(e);
                        }
                    }
                });
            }
        });
    }
}

