/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.services;

import android.support.annotation.NonNull;
import com.voxeet.sdk.AbstractVoxeetService;
import com.voxeet.sdk.VoxeetSdk;
import com.voxeet.sdk.events.sdk.MessageReceived;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.models.Conference;
import com.voxeet.sdk.models.User;
import com.voxeet.sdk.models.v2.ChatMessage;
import com.voxeet.sdk.services.CommandService;
import com.voxeet.sdk.services.ConferenceService;
import com.voxeet.sdk.services.SessionService;
import com.voxeet.sdk.services.chat.ChatMessageEvent;
import com.voxeet.sdk.services.chat.InternalChatMessage;
import com.voxeet.sdk.services.holder.ServiceProviderHolder;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;
import eu.codlab.simplepromise.Promise;
import eu.codlab.simplepromise.solve.PromiseSolver;
import eu.codlab.simplepromise.solve.Solver;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

@Annotate
public class ChatService
extends AbstractVoxeetService {
    @NoDocumentation
    public ChatService(@NonNull VoxeetSdk instance) {
        super(instance, ServiceProviderHolder.DEFAULT);
    }

    @Subscribe
    public void onEvent(MessageReceived event) {
        InternalChatMessage chatMessage = EventsFactory.mapping(event.message, InternalChatMessage.class);
        ConferenceService conferenceService = VoxeetSdk.conference();
        if (null != conferenceService && null != chatMessage) {
            User user = conferenceService.findUserById(chatMessage.ownerId);
            EventBus.getDefault().post((Object)new ChatMessageEvent(user, new ChatMessage(chatMessage)));
        }
    }

    @NonNull
    public Promise<Boolean> sendMessage(@NonNull Conference conference, @NonNull ChatMessage chatMessage) {
        User user;
        InternalChatMessage internalChatMessage;
        String json;
        SessionService sessionService = VoxeetSdk.session();
        CommandService commandService = VoxeetSdk.command();
        if (null != sessionService && null != commandService && null != (json = EventsFactory.getJson(internalChatMessage = new InternalChatMessage("Chat_Message", user = new User(sessionService.getUserId(), sessionService.getUserInfo()), chatMessage)))) {
            return commandService.send(conference.getId(), json);
        }
        return new Promise<Boolean>(new PromiseSolver<Boolean>(){

            @Override
            public void onCall(@NonNull Solver<Boolean> solver) {
                try {
                    throw new IllegalStateException("The sdk is not initialized");
                }
                catch (Exception e) {
                    solver.reject(e);
                    return;
                }
            }
        });
    }
}

