/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.network.websocket;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.voxeet.authent.user_agent.UserAgentHelper;
import com.voxeet.sdk.VoxeetHttp;
import com.voxeet.sdk.events.error.HttpException;
import com.voxeet.sdk.factories.EventsFactory;
import com.voxeet.sdk.network.websocket.ConnectListener;
import com.voxeet.sdk.network.websocket.KeepAlive;
import com.voxeet.sdk.network.websocket.SocketListener;
import com.voxeet.sdk.services.authenticate.WebSocketState;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class WebSocketProxy
implements Runnable {
    private static final long DELAY_PING = 30000L;
    private static HandlerThread HANDLER_THREAD_SOCKETS = null;
    private static final Handler HANDLER = new Handler();
    private static final int MAXIMUM_RETRY = 60;
    private static final long SOCKET_RETRY_MAX = 2000L;
    private static final long SOCKET_RETRY_AFTER = 500L;
    private static final String TAG = WebSocketProxy.class.getSimpleName();
    private String mVersionName;
    private WebSocketState mState;
    private Handler mHandler;
    private String mSocketUrl;
    private int mCount = 0;
    private boolean shouldRetry = true;
    private WebSocketListener mAdapter;
    private List<SocketListener> mListeners;
    private long mSocketCurrentRetryDelay;
    private WebSocket mWebSocket;
    private ConnectListener mConnectListener;
    private boolean isCanceled = false;
    private VoxeetHttp mProvider;
    private int seq = 0;
    private boolean pinging = false;
    private Runnable pingRunnable = new Runnable(){

        @Override
        public void run() {
            if (WebSocketProxy.this.pinging) {
                String json = EventsFactory.getJson(new KeepAlive(WebSocketProxy.this.seq++));
                if (null == json) {
                    json = "{}";
                }
                Log.d((String)TAG, (String)("run: sending ping : " + json));
                WebSocketProxy.this.mWebSocket.send(json);
                if (WebSocketProxy.this.pinging) {
                    WebSocketProxy.this.mHandler.postDelayed(WebSocketProxy.this.pingRunnable, 30000L);
                }
            }
        }
    };

    public WebSocketProxy(@NonNull String socketUrl, String versionName) {
        this.mVersionName = versionName;
        this.mState = WebSocketState.CLOSED;
        this.mSocketUrl = socketUrl;
        if (null == HANDLER_THREAD_SOCKETS) {
            HANDLER_THREAD_SOCKETS = new HandlerThread("HANDLER_THREAD_SOCKETS");
            HANDLER_THREAD_SOCKETS.start();
        }
        this.mHandler = new Handler(HANDLER_THREAD_SOCKETS.getLooper());
        this.mListeners = new ArrayList<SocketListener>();
        this.mSocketCurrentRetryDelay = 500L;
        this.mCount = 0;
        this.mAdapter = new WebSocketListener(){

            public void onOpen(@NonNull WebSocket websocket, @NonNull Response response) {
                Log.d((String)TAG, (String)("onOpen: websocket:=" + websocket + " response:=" + response));
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.startPing();
                WebSocketProxy.this.mWebSocket = websocket;
                WebSocketProxy.this.mState = WebSocketState.CONNECTED;
                WebSocketProxy.this.mSocketCurrentRetryDelay = 500L;
                WebSocketProxy.this.mCount = 0;
                WebSocketProxy.this.shouldRetry = true;
                try {
                    WebSocketProxy.this.attemptConnectListenerConnected(websocket);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.onStateChanged(websocket, WebSocketProxy.this.mState);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onConnect(websocket);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onMessage(@NonNull WebSocket websocket, @NonNull String message) {
                Log.d((String)TAG, (String)("onMessage: websocket:=" + websocket + " message:=" + message));
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onTextMessage(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onFailure(@NonNull WebSocket websocket, @NonNull Throwable cause, Response response) {
                Log.d((String)TAG, (String)("onFailure: websocket:=" + websocket + " cause:=" + cause + " isCanceled" + WebSocketProxy.this.isCanceled));
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.stopPing();
                cause.printStackTrace();
                Log.d((String)TAG, (String)("onClosed: cause:=" + cause));
                this.sendInitialFailed(response);
                this.checkRetry(websocket, cause.getMessage());
            }

            public void onClosing(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.stopPing();
                WebSocketProxy.this.mState = WebSocketState.CLOSING;
            }

            public void onClosed(@NonNull WebSocket webSocket, int code, @NonNull String reason) {
                Log.d((String)TAG, (String)("onClosed: websocket:=" + webSocket + " code:=" + code + " reason" + reason));
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                WebSocketProxy.this.stopPing();
                Log.d((String)TAG, (String)("onClosed: code:=" + code + " reason:=" + reason));
                this.checkRetry(webSocket, reason);
            }

            private void sendInitialFailed(@Nullable Response response) {
                HttpException error = HttpException.throwResponse(response);
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onError(error);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private void checkRetry(@NonNull WebSocket websocket, @Nullable String reason) {
                Log.d((String)TAG, (String)("onClosed: reason := " + reason + " shouldRetry:=" + WebSocketProxy.this.shouldRetry));
                if (WebSocketProxy.this.shouldRetry) {
                    if (WebSocketProxy.this.mCount < 60) {
                        WebSocketProxy.this.mState = WebSocketState.CONNECTING;
                        WebSocketProxy.this.mCount++;
                        WebSocketProxy.this.mSocketCurrentRetryDelay = Math.min(WebSocketProxy.this.mSocketCurrentRetryDelay * 2L, 2000L);
                        HANDLER.postDelayed((Runnable)WebSocketProxy.this, WebSocketProxy.this.mSocketCurrentRetryDelay);
                    } else {
                        WebSocketProxy.this.mState = WebSocketState.CLOSED;
                        WebSocketProxy.this.attemptConnectListenerDisconnected();
                        WebSocketProxy.this.onDisconnected();
                    }
                } else {
                    WebSocketProxy.this.mState = WebSocketState.CLOSED;
                    this.onStateChanged(websocket, WebSocketProxy.this.mState);
                    WebSocketProxy.this.onDisconnected();
                }
            }

            void onStateChanged(WebSocket websocket, WebSocketState newState) {
                if (WebSocketProxy.this.isCanceled) {
                    WebSocketProxy.this.checkCancel();
                    return;
                }
                for (SocketListener listener : WebSocketProxy.this.mListeners) {
                    try {
                        listener.onStateChanged(newState);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    private void attemptConnectListenerDisconnected() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnectError(new HttpException((Response)null));
            this.mConnectListener = null;
        }
    }

    private void attemptConnectListenerConnected(WebSocket webSocket) {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        if (this.mConnectListener != null) {
            this.mConnectListener.onConnect(webSocket);
            this.mConnectListener = null;
        }
    }

    @Nullable
    private Request setWebSocketRequest() {
        if (this.isCanceled) {
            this.checkCancel();
            return null;
        }
        String socketUrl = this.mSocketUrl;
        String jwtToken = this.mProvider.getJwtToken();
        if (null != jwtToken) {
            socketUrl = !socketUrl.contains("?") ? socketUrl + "?Token=" + jwtToken : socketUrl + "Token=" + jwtToken;
            Log.d((String)TAG, (String)("setWebSocketRequest: socketUrl := " + this.mSocketUrl + " has Token :=" + !TextUtils.isEmpty((CharSequence)jwtToken)));
            return UserAgentHelper.setUserAgent((Request.Builder)new Request.Builder(), (String)this.mVersionName).url(socketUrl).build();
        }
        return null;
    }

    public void connect(@NonNull VoxeetHttp provider, @Nullable ConnectListener connectListener) {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        this.mConnectListener = connectListener;
        this.mProvider = provider;
        Request request = this.setWebSocketRequest();
        if (null != request) {
            this.mState = WebSocketState.CONNECTING;
            this.mWebSocket = provider.getClient().newWebSocket(request, this.mAdapter);
        }
    }

    private void onDisconnected() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        for (SocketListener listener : this.mListeners) {
            listener.onDisconnected();
        }
    }

    public void addListener(@NonNull SocketListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(@NonNull SocketListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void run() {
        if (this.isCanceled) {
            this.checkCancel();
            return;
        }
        this.connect(this.mProvider, this.mConnectListener);
    }

    public boolean isOpen() {
        return WebSocketState.CONNECTED.equals((Object)this.mState);
    }

    public void disconnect() {
        this.stopPing();
        this.mState = WebSocketState.CLOSED;
        this.mCount = 60;
        this.shouldRetry = false;
        if (null != this.mWebSocket) {
            this.mWebSocket.close(1000, "Closing socket from client");
        }
        for (SocketListener listener : this.mListeners) {
            listener.onClose();
        }
    }

    public void removeListeners() {
        this.mListeners.clear();
        this.mAdapter = null;
    }

    public WebSocketState getState() {
        return this.mState;
    }

    public WebSocket getWebSocket() {
        return this.mWebSocket;
    }

    private void checkCancel() {
        Log.d((String)TAG, (String)("checkCancel: isCanceled:=" + this.isCanceled + " isOpen:=" + this.isOpen()));
        if (this.isCanceled && this.isOpen()) {
            this.disconnect();
        }
    }

    public void cancel() {
        this.removeListeners();
        this.isCanceled = true;
    }

    private void startPing() {
        if (!this.pinging) {
            Log.d((String)TAG, (String)"startPing");
            this.pinging = true;
            this.mHandler.postDelayed(this.pingRunnable, 30000L);
        }
    }

    private void stopPing() {
        if (this.pinging) {
            Log.d((String)TAG, (String)"stopPing");
            this.pinging = false;
            this.mHandler.removeCallbacks(this.pingRunnable);
        }
    }
}

