/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.sdk.network.endpoints;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;

public interface ISdkFilePresentationRService {
    @Multipart
    @POST(value="v1/files/convert")
    public Call<ResponseBody> convertFile(@Part(value="description") RequestBody var1, @Part MultipartBody.Part var2);

    @POST(value="/v1/conferences/{conferenceId}/filepresentation/start")
    public Call<ResponseBody> startFilePresentation(@Path(value="conferenceId") String var1, @Body FilePresentationId var2);

    @POST(value="/v1/conferences/{conferenceId}/filepresentation/stop")
    public Call<ResponseBody> stopFilePresentation(@Path(value="conferenceId") String var1, @Body FilePresentationId var2);

    @POST(value="/v1/conferences/{conferenceId}/filepresentation/update")
    public Call<ResponseBody> updateFilePresentation(@Path(value="conferenceId") String var1, @Body FilePresentationId var2);

    public static class FilePresentationId {
        @NonNull
        public String fileId;
        @Nullable
        public String title;
        public int position;
        public int imageCount;

        private FilePresentationId() {
        }

        public FilePresentationId(String file_id) {
            this.fileId = file_id;
        }

        public FilePresentationId(String file_id, String title, int position, int imageCount) {
            this.fileId = file_id;
            this.title = title;
            this.position = position;
            this.imageCount = imageCount;
        }

        public FilePresentationId(String fileId, int position) {
            this(fileId);
            this.position = position;
        }
    }
}

